/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.dataitem;

import com.ericsson.charging.common.dataitem.AbstractSingleDataItem;
import java.math.BigDecimal;

public class DecimalDataItem
extends AbstractSingleDataItem {
    private double myValue;
    private double myMin = Double.NEGATIVE_INFINITY;
    private double myMax = Double.POSITIVE_INFINITY;
    private int myDecimals = 0;

    public DecimalDataItem(double value) {
        super(new BigDecimal(value));
        this.myValue = value;
    }

    public DecimalDataItem(double value, double min, double max, int decimals) {
        super(new BigDecimal(value));
        this.myValue = value;
        this.myMin = min;
        this.myMax = max;
        this.myDecimals = decimals;
    }

    @Override
    public Object getDataItem(Object reference) {
        return new BigDecimal(this.myValue);
    }

    @Override
    public Object getDataItem() {
        return new BigDecimal(this.myValue);
    }

    @Override
    protected boolean performSetDataItem(Object reference, Object object) {
        if (object instanceof BigDecimal) {
            this.myValue = ((BigDecimal)object).doubleValue();
        } else {
            String value = object.toString();
            try {
                this.myValue = Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public double getValue() {
        return this.myValue;
    }

    public void setValue(double value) {
        this.setDataItem(null, new BigDecimal(value));
    }

    public double getMinValue() {
        return this.myMin;
    }

    public double getMaxValue() {
        return this.myMax;
    }

    public int getDecimalsValue() {
        return this.myDecimals;
    }

    public String toString() {
        return Double.toString(this.myValue);
    }
}

