/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.dataitem;

import com.ericsson.charging.common.dataitem.AbstractSingleDataItem;

public class IntegerDataItem
extends AbstractSingleDataItem {
    private int myValue;
    private long myMin = Integer.MIN_VALUE;
    private long myMax = Integer.MAX_VALUE;

    public IntegerDataItem(int value) {
        super(new Integer(value));
        this.myValue = value;
    }

    public IntegerDataItem(int value, long min, long max) {
        super(new Integer(value));
        this.myValue = value;
        this.myMin = min;
        this.myMax = max;
    }

    @Override
    public Object getDataItem(Object reference) {
        return new Integer(this.myValue);
    }

    @Override
    public Object getDataItem() {
        return new Integer(this.myValue);
    }

    @Override
    protected boolean performSetDataItem(Object reference, Object object) {
        if (object instanceof Integer) {
            this.myValue = (Integer)object;
        } else {
            String value = object.toString();
            try {
                this.myValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public int getValue() {
        return this.myValue;
    }

    public void setValue(int value) {
        this.setDataItem(null, new Integer(value));
    }

    public long getMinValue() {
        return this.myMin;
    }

    public long getMaxValue() {
        return this.myMax;
    }

    public String toString() {
        return Integer.toString(this.myValue);
    }
}

