/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.Reflection;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class ParametersBuilderFactory {
    private static final ThreadLocal<Object> CURRENT_PARAMETERS = new ThreadLocal();
    private static final LoadingCache<Class<?>, Object> PROXY_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Object>(){

        @Override
        public Object load(Class<?> key) throws Exception {
            return ParametersBuilderFactory.newProxyInstance(key);
        }
    });

    public static <FIRST, TARGET> FIRST create(Class<FIRST> firstType, TARGET instance) {
        return ParametersBuilderFactory.createProxy(firstType, instance);
    }

    public static <BUILDER, TARGET> void verifyInterface(Class<BUILDER> builderInterface, TARGET instance) {
        ParametersBuilderFactory.verifyInterface(builderInterface, instance, 0);
    }

    private static <BUILDER, TARGET> void verifyInterface(Class<BUILDER> builderInterface, TARGET instance, int level) {
        Preconditions.checkArgument(level < 20, "This is getting out of control. The interfaces are cyclic or you are adding way too many arguments to your method.");
        String builderClassName = builderInterface.getSimpleName();
        Class<?> instanceClass = instance.getClass();
        String instanceClassName = instanceClass.getSimpleName();
        Preconditions.checkArgument(builderInterface.isInterface(), builderClassName + " must be an interface");
        for (Method m : builderInterface.getMethods()) {
            if (OptionalParameters.class.isAssignableFrom(builderInterface) && m.getName().equals("get")) continue;
            String parameterName = m.getName();
            Preconditions.checkArgument(m.getParameterTypes().length == 1, "Method " + parameterName + " must only contain one parameter");
            Type targetType = m.getGenericParameterTypes()[0];
            Preconditions.checkArgument(m.getReturnType().isInterface(), "Return type for " + parameterName + " must be an interface");
            Field instanceField = ParametersBuilderFactory.getField(instanceClass, parameterName);
            Preconditions.checkArgument(instanceField != null, "Field with name " + parameterName + " missing in " + instanceClassName);
            Type fieldType = instanceField.getGenericType();
            if (OptionalParameters.class.isAssignableFrom(builderInterface)) {
                if (fieldType instanceof ParameterizedType) {
                    Preconditions.checkArgument(((ParameterizedType)fieldType).getRawType() == Optional.class && ((ParameterizedType)fieldType).getActualTypeArguments()[0].equals(targetType), "Instance field " + parameterName + " must be Optional<" + targetType.getTypeName() + ">");
                    Preconditions.checkArgument(ParametersBuilderFactory.getFieldValue(instance, instanceField) == Optional.empty(), "Instance field " + parameterName + " must be initialized to Optional.empty()");
                } else {
                    Preconditions.checkArgument(false, "Instance field " + parameterName + " must be Optional<" + targetType.getTypeName() + ">");
                }
            } else {
                Preconditions.checkArgument(fieldType.equals(targetType), "Instance field " + parameterName + " must be " + String.valueOf(targetType) + " but was " + String.valueOf(fieldType));
            }
            if (m.getReturnType() == builderInterface) continue;
            ParametersBuilderFactory.verifyInterface(m.getReturnType(), instance, ++level);
        }
    }

    private static <BUILDER, TARGET> BUILDER createProxy(Class<BUILDER> targetType, TARGET instance) {
        CURRENT_PARAMETERS.set(instance);
        return (BUILDER)PROXY_CACHE.getUnchecked(targetType);
    }

    private static Object newProxyInstance(final Class<?> targetType) {
        return Reflection.newProxy(targetType, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object instance = CURRENT_PARAMETERS.get();
                if (OptionalParameters.class.isAssignableFrom(targetType) && method.getName().equals("get")) {
                    CURRENT_PARAMETERS.remove();
                    return instance;
                }
                Field field = instance.getClass().getDeclaredField(method.getName());
                Object value = OptionalParameters.class.isAssignableFrom(targetType) ? Optional.ofNullable(args[0]) : Preconditions.checkNotNull(args[0], "Parameter " + method.getName() + " is mandatory and must not be null");
                field.setAccessible(true);
                field.set(instance, value);
                return ParametersBuilderFactory.createProxy(method.getReturnType(), instance);
            }
        });
    }

    private static Field getField(Class<?> instanceClass, String parameterName) {
        try {
            return instanceClass.getDeclaredField(parameterName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException("Missing field " + parameterName + " in " + instanceClass.getSimpleName(), e);
        }
    }

    private static Object getFieldValue(Object instance, Field instanceField) {
        try {
            instanceField.setAccessible(true);
            return instanceField.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw Throwables.propagate(e);
        }
    }

    public static interface OptionalParameters<T> {
        public T get();
    }
}

