/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc;

import com.ericsson.em.emc.UserErrorCode;
import com.ericsson.em.emc.UserException;
import java.util.HashMap;
import java.util.Map;

public class UserExceptionBuilder {
    private final UserErrorCode errorCode;
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private final Map<String, Object> extraArguments = new HashMap<String, Object>();
    private UserErrorCode originalErrorCode;

    public UserExceptionBuilder(UserErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public UserExceptionBuilder add(String name, Object value) {
        if (!this.errorCode.getArgumentNames().contains(name)) {
            throw new IllegalArgumentException(String.format("UserErrorCode %s does not contain argument %s", this.errorCode.toString(), name));
        }
        this.arguments.put(name, value);
        return this;
    }

    public UserExceptionBuilder addExtraArguments(Map<String, ?> arguments) {
        this.extraArguments.putAll(arguments);
        return this;
    }

    public UserExceptionBuilder addOriginalErrorCode(UserErrorCode originalErrorCode) {
        this.originalErrorCode = originalErrorCode;
        return this;
    }

    public UserException create() {
        if (this.arguments.size() != this.errorCode.getArgumentNames().size()) {
            StringBuffer missingNamesBuf = new StringBuffer();
            for (String name : this.errorCode.getArgumentNames()) {
                if (this.arguments.containsKey(name)) continue;
                missingNamesBuf.append(name);
                missingNamesBuf.append(", ");
            }
            String missingNames = missingNamesBuf.toString().substring(0, missingNamesBuf.length() - 2);
            throw new IllegalArgumentException(String.format("Missing arguments: %s", missingNames));
        }
        if (this.originalErrorCode == null) {
            return new UserException(this.errorCode, this.arguments, this.extraArguments);
        }
        return new UserException(this.errorCode, this.arguments, this.extraArguments, this.originalErrorCode);
    }
}

