/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.activator;

import com.ericsson.em.emc.activator.LegacyFingerPrintActivationManager;
import com.ericsson.lwac.crypto.fingerprint.persistence.FingerprintStatus;
import com.ericsson.lwac.crypto.fingerprint.persistence.LegacyFingerPrintControl;
import com.ericsson.lwac.crypto.fingerprint.persistence.LegacyFingerPrintControlDAO;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Arrays;
import java.util.List;

@Singleton
public class LegacyFingerPrintActivationManagerBean
implements LegacyFingerPrintActivationManager {
    @EJB
    private LegacyFingerPrintControlDAO legacyFingerPrintControlDAO;
    private static final List<String> TABLES_TO_BE_FINGERPRINTED = Arrays.asList("ahc$scope", "emm$accountsupervisor", "emm$agentinformation", "emm$auth_question", "emm$balancebucket", "emm$credentialtype", "emm$ftexemption", "emm$nettedcatrans", "emm$nettedcatschedule", "emm$notification_message", "emm$onaggregatedcommission", "emm$pendingbonus", "emm$persistenttask", "hier$counterconfiguration", "hier$countermatchrule", "hier$globalparameter", "hier$modifierconfiguration", "hier$modifiermatchrule", "hier$profile", "hier$profilecounterrelation", "hier$properties", "hier$service", "hier$sharedcounterconfig", "hier$thresholdmatchrule", "ovdr$ruleprofilereference", "qm$quota", "sp$pendingfrilink", "hier$thresholdconfig");
    private static final List<String> TABLES_ON_HOLD = Arrays.asList("er$keepalive", "emm$credentialownerreference", "hier$counterbalance", "hier$counterbalreserv", "hier$profilereference");

    @Override
    public void insertIntoLegacyFingerprintRecordsWithValidFingerprint() {
        if (this.legacyFingerPrintControlDAO.getNrOfEntries() == 0L) {
            try {
                this.createRecordsWithValidFingerprint();
            }
            catch (Exception e) {
                throw new RuntimeException("Insertion of records into legacy control table failed.", e);
            }
        }
    }

    private void createRecordsWithValidFingerprint() {
        TABLES_TO_BE_FINGERPRINTED.forEach(tableName -> this.legacyFingerPrintControlDAO.create(new LegacyFingerPrintControl(tableName, FingerprintStatus.NOT_FINGERPRINTED)));
        TABLES_ON_HOLD.forEach(tableName -> this.legacyFingerPrintControlDAO.create(new LegacyFingerPrintControl(tableName, FingerprintStatus.FINGERPRINT_ONHOLD)));
    }
}

