/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.audittrail.comparator.impl;

import com.ericsson.em.emc.audittrail.comparator.Comparator;
import com.ericsson.em.emc.audittrail.comparator.ReflectionComparator;
import com.ericsson.em.emc.m3externallog.json.comparator.ChangeField;
import com.ericsson.em.emc.m3externallog.json.comparator.Difference;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.utilities.StringUtilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEntityComparator
implements Comparator {
    private final List<BaseEntity> visited = new ArrayList<BaseEntity>();
    private static final Logger logger = LoggerFactory.getLogger(BaseEntityComparator.class);

    @Override
    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return left instanceof BaseEntity && right instanceof BaseEntity;
    }

    @Override
    public Difference compare(Object left, Object right, ReflectionComparator reflectionComparator) {
        BaseEntity before = (BaseEntity)left;
        BaseEntity after = (BaseEntity)right;
        Difference difference = new Difference();
        if (before == null && after == null) {
            return difference;
        }
        if (this.visited.contains(before) && this.visited.contains(after)) {
            return difference;
        }
        if (before != null) {
            this.visited.add(before);
        }
        if (after != null) {
            this.visited.add(after);
        }
        if (before == null && after != null) {
            difference.getChangeFields().add(this.createEntityChangeFields(after, null, after));
            return difference;
        }
        if (before != null && after == null) {
            difference.getChangeFields().add(this.createEntityChangeFields(before, before, null));
            return difference;
        }
        try {
            if (before != null) {
                for (Method m : before.getClass().getMethods()) {
                    Object afterField;
                    String methodName;
                    if ((m.getModifiers() & 1) != 1 || ((methodName = m.getName()).startsWith("getVersion") || !methodName.startsWith("get")) && !methodName.startsWith("is") || m.getParameterTypes().length != 0) continue;
                    String remove = methodName.startsWith("get") ? "get" : "is";
                    String fieldName = methodName.substring(remove.length());
                    Object beforeField = m.invoke((Object)before, new Object[0]);
                    Difference fieldDifference = reflectionComparator.compare(beforeField, afterField = m.invoke((Object)after, new Object[0]));
                    if (fieldDifference.isEmpty()) continue;
                    for (ChangeField changeField : fieldDifference.getChangeFields()) {
                        difference.getChangeFields().add(changeField);
                        if (changeField.getId() != null || !StringUtilities.isEmpty(changeField.getFieldName()) || !StringUtilities.isEmpty(changeField.getClassName())) continue;
                        changeField.setFieldName(fieldName);
                        changeField.setClassName(this.getClassName(before));
                        changeField.setId(before.getId());
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Exception in getDifference", e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("Exception in getDifference", e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("Exception in getDifference", e);
            throw new RuntimeException(e);
        }
        return difference;
    }

    private ChangeField createEntityChangeFields(BaseEntity entity, String fieldName, Object before, Object after) {
        return new ChangeField(entity.getId(), this.getClassName(entity), fieldName, before, after);
    }

    private ChangeField createEntityChangeFields(BaseEntity entity, Object before, Object after) {
        return this.createEntityChangeFields(entity, null, before, after);
    }

    private <T> String getClassName(T before) {
        return before.getClass().getSimpleName();
    }
}

