/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.certificate;

import com.ericsson.em.privacy.PersonalData;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.crypto.util.ByteArrays;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.ExtendedBaseEntityDAOBean;
import java.sql.Timestamp;
import java.util.Date;

public class Certificate
extends BaseEntity {
    private static final long serialVersionUID = 7967675453000960233L;
    @PersonalData(type={PersonalData.PersonalDataType.CERTIFICATE})
    private byte[] certificate = null;
    private byte[] hashedCertificate = null;
    private Timestamp expiryTime = null;

    public byte[] getCertificate() {
        return ByteArrays.safeCopy((byte[])this.certificate);
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = ByteArrays.safeCopy((byte[])certificate);
    }

    public byte[] getHashedCertificate() {
        return ByteArrays.safeCopy((byte[])this.hashedCertificate);
    }

    public void setHashedCertificate(byte[] hashedCertificate) {
        this.hashedCertificate = ByteArrays.safeCopy((byte[])hashedCertificate);
    }

    public Timestamp getExpiryTime() {
        return ExtendedBaseEntityDAOBean.getTimestamp((Date)this.expiryTime);
    }

    public void setExpiryTime(Timestamp expiryTime) {
        this.expiryTime = ExtendedBaseEntityDAOBean.getTimestamp((Date)expiryTime);
    }

    protected void validate() {
        if (this.certificate == null) {
            throw new ValidationException("Missing certificate");
        }
        if (this.hashedCertificate == null) {
            throw new ValidationException("Missing certificate hash");
        }
        if (this.expiryTime == null) {
            throw new ValidationException("Missing certificate expiry time");
        }
        super.validate();
    }
}

