/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.certificate.Certificate;
import com.ericsson.em.emc.certificate.CertificateDAO;
import com.ericsson.em.emc.certificate.CertificateManager;
import com.ericsson.em.emc.credential.CertificateCredentialManager;
import com.ericsson.em.emc.credential.CredentialOwner;
import com.ericsson.em.emc.credential.persistence.CertificateCredential;
import com.ericsson.em.emc.credential.persistence.CertificateCredentialDAO;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.joda.time.DateTime;

@Singleton
public class CertificateCredentialManagerBean
implements CertificateCredentialManager {
    @EJB
    private CertificateCredentialDAO certificateCredentialDAO;
    @EJB
    private CertificateDAO certificateDAO;
    @EJB
    private CertificateManager certificateManager;

    @Override
    public CertificateCredential createCertificateCredential(CredentialOwner credentialOwner, X509Certificate x509Certificate) throws CertificateException, NoSuchAlgorithmException {
        CertificateCredential certificateCredential = null;
        certificateCredential = this.certificateCredentialDAO.findByCredentialOwnerReference(credentialOwner.getCredentialOwnerReference());
        if (certificateCredential != null) {
            throw new UserExceptionBuilder(CoreUserErrorCode.CERTIFICATE_CREDENTIALS_ALREADY_EXIST).create();
        }
        if (x509Certificate != null) {
            Certificate certificate = this.certificateManager.createCertificate(x509Certificate);
            certificateCredential = new CertificateCredential();
            certificateCredential.setCredentialOwnerReferenceId(credentialOwner.getCredentialOwnerReference().getId());
            certificateCredential.setCertificateId(certificate.getId());
            certificateCredential = this.certificateCredentialDAO.create(certificateCredential);
        }
        return certificateCredential;
    }

    @Override
    public CertificateCredential findByCertificate(X509Certificate x509Certificate) throws CertificateException, NoSuchAlgorithmException {
        Certificate certificate = this.certificateManager.find(x509Certificate);
        CertificateCredential certificateCredential = null;
        if (certificate != null) {
            certificateCredential = this.certificateCredentialDAO.findByCertificate(certificate);
        }
        return certificateCredential;
    }

    @Override
    public CertificateCredential updateCertificateCredential(CredentialOwner credentialOwner, X509Certificate x509Certificate) throws CertificateException, NoSuchAlgorithmException {
        CertificateCredential certificateCredential = null;
        CertificateCredential newCertificateCredential = null;
        Certificate certificate = null;
        if (x509Certificate != null) {
            byte[] newSecret = null;
            certificateCredential = this.certificateCredentialDAO.findByCredentialOwnerReference(credentialOwner.getCredentialOwnerReference());
            if (certificateCredential != null) {
                certificate = this.certificateDAO.find(certificateCredential.getCertificateId());
                byte[] oldSecret = certificate.getHashedCertificate();
                if (Arrays.equals(oldSecret, newSecret = this.certificateManager.getHashedCertificate(x509Certificate))) {
                    throw new UserExceptionBuilder(CoreUserErrorCode.CERTIFICATE_ALREADY_UPDATED).create();
                }
            } else {
                throw new UserExceptionBuilder(CoreUserErrorCode.CERTIFICATE_CREDENTIALS_NOT_FOUND).create();
            }
            this.certificateManager.deleteCertificate(certificateCredential.getCertificateId());
            certificate = this.certificateManager.createCertificate(x509Certificate);
            if (certificate != null) {
                newCertificateCredential = new CertificateCredential();
                newCertificateCredential.setCredentialOwnerReferenceId(certificateCredential.getCredentialOwnerReferenceId());
                newCertificateCredential.setCertificateId(certificate.getId());
                this.certificateCredentialDAO.create(newCertificateCredential);
            }
        }
        return newCertificateCredential;
    }

    @Override
    public void deleteCertificateCredential(CredentialOwner credentialOwner) {
        CertificateCredential certificateCredential = this.certificateCredentialDAO.findByCredentialOwnerReference(credentialOwner.getCredentialOwnerReference());
        if (certificateCredential == null) {
            throw new UserExceptionBuilder(CoreUserErrorCode.CERTIFICATE_CREDENTIALS_NOT_FOUND).create();
        }
        Certificate certificate = this.certificateDAO.find(certificateCredential.getCertificateId());
        this.certificateDAO.delete(certificate);
    }

    @Override
    public byte[] getHashedCertificate(X509Certificate x509Certificate) throws CertificateException, NoSuchAlgorithmException {
        return this.certificateManager.getHashedCertificate(x509Certificate);
    }

    @Override
    public void registerSuccessfulLogin(CredentialOwner credentialOwner) {
        CertificateCredential certificateCredential = this.certificateCredentialDAO.findByCredentialOwnerReference(credentialOwner.getCredentialOwnerReference());
        if (certificateCredential != null) {
            certificateCredential.setLastLoginTimestamp(certificateCredential.getLoginTimestamp());
            certificateCredential.setLoginTimestamp(new DateTime());
            this.certificateCredentialDAO.update(certificateCredential);
        }
    }

    @Override
    public CertificateCredential findByCredentialOwner(CredentialOwner credentialOwner) {
        return this.certificateCredentialDAO.findByCredentialOwnerReference(credentialOwner.getCredentialOwnerReference());
    }
}

