/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.exception;

import com.ericsson.lwac.ErrorCode;

public enum CredentialErrorCode implements ErrorCode
{
    CREDENTIAL_MISSING_CREDENTIAL_OWNER_REFERENCE(94001, "Missing credential owner reference.", 0),
    CREDENTIAL_MISSING_CREDENTIAL_TYPE(94002, "Missing credential type identity.", 0),
    CREDENTIAL_MISSING_HASHED_PASSWORD(94003, "Missing hashed password.", 0),
    CREDENTIAL_EMPTY_HASHED_PASSWORD(94004, "The hashed password cannot be empty.", 0),
    CREDENTIAL_MISSING_CREATION_DATE(94005, "Missing creation date.", 0),
    CREDENTIAL_MISSING_CREDENTIAL_STATUS(94006, "Missing credential status.", 0),
    CREDENTIAL_MISSING_HASH_VERSION(94007, "Missing hash version.", 0),
    CREDENTIAL_UNKNOWN_FINGERPRINT_VERSION(94008, "Unknown fingerprint version %d", 1),
    CREDENTIAL_TYPE_MISSING_NAME(94009, "Missing name.", 0),
    CREDENTIAL_MISSING_CHANGE_DATE(94010, "Missing change date.", 0),
    CREDENTIAL_ILLEGAL_ARGUMENT(94011, "Argument '%s' cannot be null.", 1),
    CREDENTIAL_ACCOUNT_HOLDER_NOT_ACTIVE(94012, "The account holder is not active.", 0),
    CREDENTIAL_INCORRECT_SEQURITY_ANSWER(94013, "Incorrect answer to security question.", 0),
    CREDENTIAL_REQUIRED_CREDENTIAL_DOES_NOT_EXIST(94016, "Required credential does not exist.", 0),
    CREDENTIAL_NOT_BLOCKED(94017, "Credential is not blocked.", 0),
    CREDENTIAL_AUTHENTICATION_FAILED_BLOCKED(94018, "Authentication failed. Credential is not active. Current credential status is blocked.", 0),
    CREDENTIAL_AUTHENTICATION_FAILED_MULTIPLE_FAILED_BLOCKED(94019, "Authentication failed. Multiple failed login attempts detected. Current credential status is blocked.", 0),
    CREDENTIAL_MISSING_FAILED_LOGINS(94020, "Missing failed login attempts.", 0),
    CREDENTIAL_INCORRECT_PASSWORD(94022, "Supplied password does not match stored password.", 0),
    CREDENTIAL_MISSING_NEW_PASSWORD(94025, "Missing new password.", 0),
    CREDENTIAL_MISSING_PROVIDER(94026, "Missing password service provider for %s.", 1),
    CREDENTIAL_NOT_ACTIVE(94050, "Credential not active.", 0),
    CREDENTIAL_NOT_INACTIVE(94051, "Credential not inactive.", 0),
    CREDENTIAL_INCORRECT_STATUS(94052, "Credential in wrong status %s.", 1);

    private static final int ERRORGROUP = 94;
    private final int id;
    private final String message;
    private final int numOfArguments;

    private CredentialErrorCode(int id, String message, int numOfArgs) {
        this.id = id;
        this.message = message;
        this.numOfArguments = numOfArgs;
    }

    @Override
    public int getErrorCode() {
        return this.id % 1000;
    }

    @Override
    public int getErrorGroup() {
        return 94;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public int getNumOfArgs() {
        return this.numOfArguments;
    }
}

