/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.hash;

import com.ericsson.em.emc.credential.CredentialKeyDomainService;
import com.ericsson.em.emc.credential.CredentialKeyUsage;
import com.ericsson.em.emc.credential.hash.HashManager;
import com.ericsson.lwac.ObjectHelperFactory;
import com.ericsson.lwac.crypto.securitymodule.KeyStoreManager;
import com.ericsson.lwac.deployer.OptionalDependency;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import com.ericsson.lwac.security.HashHandler;
import com.ericsson.lwac.security.HashVersion;
import com.ericsson.lwac.security.service.SecurityProviderException;
import com.ericsson.lwac.security.service.SecurityProviderListener;
import com.ericsson.lwac.security.service.SecurityService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Mac;

@Singleton
public class HashManagerBean
implements HashManager,
SecurityProviderListener {
    public static final String AUTH_HMAC_KEY = "Auth_HMAC";
    private static final int HMAC_HASH_VERSION_ORDINAL = 2;
    private volatile boolean isKeyStoreLoaded = false;
    @Resource
    private SecurityService securityService;
    @Resource
    private KeyStoreManager keyStoreManager;
    @Resource
    private CredentialKeyDomainService credentialKeyService;
    private static final HashHandler hashHandler = ObjectHelperFactory.createHashHandler();
    private KeyStore keyStore;
    @Resource
    @OptionalDependency
    private StatisticsService statisticsService;

    @Override
    public HashVersion getCurrentHashVersion() {
        return HashVersion.HMACSHA512DB;
    }

    @Override
    public boolean validate(Long databaseId, String plaintextCredential, HashVersion hashVersion, byte[] compareHash) {
        return this.validate(databaseId, plaintextCredential, hashVersion, compareHash, 0, CredentialKeyUsage.COMMON);
    }

    @Override
    public boolean validate(Long databaseId, String plaintextCredential, HashVersion hashVersion, byte[] compareHash, Integer keyGeneration, CredentialKeyUsage credentialKeyUsage) {
        if (databaseId == null || plaintextCredential == null || hashVersion == null || compareHash == null || plaintextCredential.isEmpty()) {
            return false;
        }
        if (hashVersion.ordinal() >= 2) {
            byte[] generatedData = this.getHashedCredential(databaseId, plaintextCredential, hashVersion, keyGeneration, credentialKeyUsage);
            if (generatedData.length == compareHash.length) {
                return Arrays.equals(generatedData, compareHash);
            }
            return false;
        }
        return hashHandler.validate(databaseId, plaintextCredential, hashVersion, compareHash);
    }

    @Override
    public byte[] getHashedCredential(Long databaseId, String plaintextCredential) {
        return this.getHashedCredential(databaseId, plaintextCredential, HashVersion.HMACSHA512DB);
    }

    @Override
    public byte[] getHashedCredential(Long databaseId, String plaintextCredential, HashVersion hashVersion) {
        return this.getHashedCredential(databaseId, plaintextCredential, hashVersion, this.credentialKeyService.getCredentialKeyGeneration(), CredentialKeyUsage.COMMON);
    }

    @Override
    public byte[] getHashedCredential(Long databaseId, String plaintextCredential, HashVersion hashVersion, CredentialKeyUsage credentialKeyUsage) {
        return this.getHashedCredential(databaseId, plaintextCredential, hashVersion, this.credentialKeyService.getCredentialKeyGeneration(), credentialKeyUsage);
    }

    @Override
    public byte[] getHashedCredential(Long databaseId, String plaintextCredential, HashVersion hashVersion, Integer keyGeneration, CredentialKeyUsage credentialKeyUsage) {
        Objects.requireNonNull(databaseId);
        Objects.requireNonNull(plaintextCredential);
        if (plaintextCredential.isEmpty()) {
            throw new IllegalArgumentException("Credential cannot be empty");
        }
        byte[] saltBytes = databaseId.toString().getBytes();
        byte[] plaintextCredentialBytes = plaintextCredential.getBytes();
        if (hashVersion.ordinal() >= 2) {
            return this.createSaltedHmacHash(saltBytes, plaintextCredentialBytes, hashVersion, keyGeneration, credentialKeyUsage);
        }
        byte[] hash = hashHandler.saltedIteratedHash(plaintextCredentialBytes, saltBytes, hashVersion);
        return hash;
    }

    @Override
    public byte[] getHmacHash(byte[] salt, byte[] data) {
        return this.createSaltedHmacHash(salt, data, HashVersion.HMACSHA512DB, this.credentialKeyService.getCredentialKeyGeneration(), CredentialKeyUsage.COMMON);
    }

    @Override
    public byte[] getHmacHash(byte[] salt, byte[] data, HashVersion hashVersion) {
        return this.createSaltedHmacHash(salt, data, hashVersion, this.credentialKeyService.getCredentialKeyGeneration(), CredentialKeyUsage.COMMON);
    }

    @Override
    public byte[] getHmacHash(byte[] salt, byte[] data, HashVersion hashVersion, Integer keyGeneration) {
        return this.createSaltedHmacHash(salt, data, hashVersion, keyGeneration, CredentialKeyUsage.COMMON);
    }

    @Override
    public boolean validateHmacHash(byte[] salt, byte[] data, byte[] oldHash) {
        byte[] generatedData = this.getHmacHash(salt, data);
        return Arrays.equals(generatedData, oldHash);
    }

    @Override
    public boolean validateHmacHash(byte[] salt, byte[] data, byte[] oldHash, HashVersion hashVersion) {
        byte[] generatedData = this.getHmacHash(salt, data, hashVersion);
        return Arrays.equals(generatedData, oldHash);
    }

    private byte[] createSaltedHmacHash(byte[] salt, byte[] input, HashVersion hashVersion, Integer keyGeneration, CredentialKeyUsage credentialKeyUsage) {
        this.lazyLoadKey(hashVersion.isDbKey());
        try {
            if (hashVersion.isDbKey()) {
                return this.createSaltedHmacHashWithDbKey(salt, input, hashVersion, keyGeneration, credentialKeyUsage);
            }
            return this.securityService.createSaltedHash(salt, input, hashVersion.toString(), AUTH_HMAC_KEY);
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException e) {
            throw new RuntimeException("Failed to create HMAC hash", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createSaltedHmacHashWithDbKey(byte[] salt, byte[] input, HashVersion hashVersion, Integer keyGeneration, CredentialKeyUsage credentialKeyUsage) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, UnrecoverableKeyException, KeyStoreException {
        Measurement measurement = null;
        try {
            if (this.statisticsService != null) {
                measurement = this.statisticsService.startMeasurment("HashManagerBean", "createSaltedHmacHashWithDbKey", StatisticsService.MeasurementType.INTERNAL);
            }
            Mac mac = Mac.getInstance(hashVersion.toString(), "SunJCE");
            mac.init(this.keyStore.getKey(this.credentialKeyService.getCredentialKeyAliasWithGeneration(keyGeneration, credentialKeyUsage), null));
            mac.update(salt);
            byte[] byArray = mac.doFinal(input);
            if (this.statisticsService != null) {
                this.statisticsService.stopMeasurement(measurement);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            if (this.statisticsService != null) {
                this.statisticsService.stopMeasurement(measurement);
            }
            throw throwable;
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.securityService.addSecurityProviderListener(this);
    }

    private void loadHmacKey(boolean isDbKey) {
        try {
            this.keyStore = this.keyStoreManager.getKeyStore();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SecurityProviderException("Failed to get keystore.", e);
        }
        if (!isDbKey) {
            this.securityService.loadSecretKey(AUTH_HMAC_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadKey(boolean isDbKey) {
        if (!this.isKeyStoreLoaded) {
            HashManagerBean hashManagerBean = this;
            synchronized (hashManagerBean) {
                if (!this.isKeyStoreLoaded) {
                    this.loadHmacKey(isDbKey);
                    this.isKeyStoreLoaded = true;
                }
            }
        }
    }

    @Override
    public void onRestart() {
        this.isKeyStoreLoaded = false;
    }
}

