/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.credential.CredentialStatus;
import com.ericsson.em.emc.credential.persistence.Credential;
import com.ericsson.em.emc.credential.persistence.CredentialDAO;
import com.ericsson.em.emc.credential.persistence.CredentialOwnerReference;
import com.ericsson.em.emc.credential.persistence.CredentialType;
import com.ericsson.em.emc.credential.persistence.SuspendedCredential;
import com.ericsson.em.emc.credential.persistence.SuspendedCredentialOwner;
import com.ericsson.em.emc.credential.persistence.SuspendedCredentialProcessor;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import com.ericsson.lwac.security.HashVersion;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.ejb.Singleton;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.joda.time.DateTime;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"emm.credential.S"})
public class CredentialDAOBean
extends CryptoExtendedBaseEntityDAOBean<Credential>
implements CredentialDAO {
    private static final String PROCESSOR_AH_LANGUAGECODE = "ah_languagecode";
    private static final String PROCESSOR_AH_EFFETIVE_MSISDN = "ah_effetive_msisdn";
    private static final String PROCESSOR_AH_MSISDN = "ah_msisdn";
    private static final String PROCESSOR_AH_EMAIL = "ah_email";
    private static final String PROCESSOR_AH_ID = "ah_id";
    private static final String COL_SUSPENDED_UNTIL = "suspendeduntil";
    private static final String COL_STATUS = "status";
    private static final String[] COLUMNS = new String[]{"id", "fk_credentialownerreference", "fk_credentialtype", "hashedpassword", "created", "status", "hashversion", "logintimestamp", "lastlogintimestamp", "failedlogins", "lastfailedlogins", "lastfailedlogintimestamp", "lastresetattempt", "keygeneration", "suspendeduntil", "fingerprint", "fingerprintversion", "fingerprintkeygeneration", "version"};
    private static final int CREDENTIAL_CURRENT_FINGERPRINT_VERSION = 5;
    public static final String CREDENTIAL_FINGERPRINT_KEY = "emm.credential.S";

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        Credential credential = (Credential)baseEntity;
        int i = 1;
        preparedStatement.setLong(i++, credential.getCredentialOwnerReferenceId());
        preparedStatement.setLong(i++, credential.getCredentialTypeId());
        preparedStatement.setBytes(i++, credential.getHashedCredential());
        preparedStatement.setObject(i++, (Object)credential.getCreated(), 93, 9);
        preparedStatement.setInt(i++, credential.getStatus().ordinal());
        preparedStatement.setInt(i++, credential.getHashVersion().toInt());
        if (credential.getLoginTimestamp() != null) {
            preparedStatement.setObject(i++, (Object)CredentialDAOBean.getTimestamp((DateTime)credential.getLoginTimestamp()), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        if (credential.getLastLoginTimestamp() != null) {
            preparedStatement.setObject(i++, (Object)CredentialDAOBean.getTimestamp((DateTime)credential.getLastLoginTimestamp()), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        preparedStatement.setInt(i++, credential.getFailedLogins());
        preparedStatement.setInt(i++, credential.getLastFailedLogins());
        if (credential.getLastFailedLoginTimestamp() != null) {
            preparedStatement.setObject(i++, (Object)CredentialDAOBean.getTimestamp((DateTime)credential.getLastFailedLoginTimestamp()), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        if (credential.getLastResetAttempt() != null) {
            preparedStatement.setObject(i++, (Object)CredentialDAOBean.getTimestamp((DateTime)credential.getLastResetAttempt()), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        preparedStatement.setInt(i++, credential.getKeyGeneration());
        DateTime suspendedUntil = credential.getSuspendedUntil();
        preparedStatement.setObject(i++, (Object)CredentialDAOBean.getTimestamp((DateTime)suspendedUntil), 93, 9);
        i = this.assignFingerprint(preparedStatement, i, new Object[]{credential.getCredentialOwnerReferenceId(), credential.getCredentialTypeId(), credential.getHashedCredential(), credential.getCreated(), credential.getStatus().ordinal(), credential.getHashVersion().toInt(), credential.getLoginTimestamp(), credential.getLastLoginTimestamp(), credential.getFailedLogins(), credential.getLastFailedLogins(), credential.getLastFailedLoginTimestamp(), credential.getLastResetAttempt(), credential.getKeyGeneration(), credential.getSuspendedUntil()});
        credential.setFingerPrintVersion(this.getFingerprintVersion());
        return i;
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        Credential credential = (Credential)baseEntity;
        credential.setCredentialOwnerReferenceId(resultSet.getLong("fk_credentialownerreference"));
        credential.setCredentialTypeId(resultSet.getLong("fk_credentialtype"));
        credential.setHashedCredential(resultSet.getBytes("hashedpassword"));
        credential.setCreated(resultSet.getTimestamp("created"));
        Integer status = resultSet.getInt(COL_STATUS);
        credential.setHashVersion(HashVersion.fromInt(resultSet.getInt("hashversion")));
        for (CredentialStatus cs : CredentialStatus.values()) {
            if (cs.ordinal() != status.intValue()) continue;
            credential.setStatus(cs);
            break;
        }
        Timestamp loginTimestamp = resultSet.getTimestamp("logintimestamp");
        Timestamp lastLoginTimestamp = resultSet.getTimestamp("lastlogintimestamp");
        Timestamp lastFailedLoginTimestamp = resultSet.getTimestamp("lastfailedlogintimestamp");
        credential.setLoginTimestamp(loginTimestamp == null ? null : new DateTime(loginTimestamp.getTime()));
        credential.setLastLoginTimestamp(lastLoginTimestamp == null ? null : new DateTime(lastLoginTimestamp.getTime()));
        credential.setFailedLogins(resultSet.getInt("failedlogins"));
        credential.setLastFailedLogins(resultSet.getInt("lastfailedlogins"));
        credential.setLastFailedLoginTimestamp(lastFailedLoginTimestamp == null ? null : new DateTime(lastFailedLoginTimestamp.getTime()));
        Timestamp lastResetAttempt = resultSet.getTimestamp("lastresetattempt");
        credential.setLastResetAttempt(lastResetAttempt == null ? null : new DateTime(lastResetAttempt.getTime()));
        credential.setKeyGeneration(resultSet.getInt("keygeneration"));
        Timestamp suspendedUntil = resultSet.getTimestamp(COL_SUSPENDED_UNTIL);
        if (suspendedUntil != null) {
            credential.setSuspendedUntil(new DateTime(suspendedUntil));
        }
        credential.setVersion(resultSet.getLong("version"));
        credential.setFingerPrintVersion(resultSet.getInt("fingerprintversion"));
    }

    protected Credential createManagedEntity() {
        return new Credential();
    }

    @Override
    public Credential find(long id) {
        return (Credential)super.find(id);
    }

    @Override
    public List<Credential> findByCredentialOwnerReference(CredentialOwnerReference credentialOwnerReference) {
        return this.findMultiple(this.getSelectStatement() + " where fk_credentialownerreference = ?", new Object[]{credentialOwnerReference.getId()});
    }

    @Override
    public Credential findOldestByCredentialOwnerReference(CredentialOwnerReference credentialOwnerReference) {
        return (Credential)this.find("select * from (" + this.getSelectStatement() + " where fk_credentialownerreference = ? order by created asc ) where rownum = 1", new Object[]{credentialOwnerReference.getId()});
    }

    @Override
    public Credential findByCredentialOwnerReferenceAndCredentialType(CredentialOwnerReference credentialOwnerReference, CredentialType credentialType) {
        return (Credential)this.find(this.getSelectStatement() + " where fk_credentialownerreference = ? and fk_credentialtype = ?", new Object[]{credentialOwnerReference.getId(), credentialType.getId()});
    }

    @Override
    public Credential create(Credential credential) {
        return (Credential)super.create((BaseEntity)credential);
    }

    @Override
    public void delete(Credential credential) {
        super.deleteWithVersionCheck((BaseEntity)credential);
    }

    @Override
    public Credential update(Credential credential) {
        return (Credential)super.updateWithVersionCheck((BaseEntity)credential);
    }

    @Override
    public void updateUnsafe(Credential credential) {
        if (credential.getFingerPrintVersion() != this.getFingerprintVersion()) {
            try {
                this.update(credential);
            }
            catch (OptimisticLockException optimisticLockException) {}
        } else {
            long currentVersion = credential.getVersion();
            String sql = "update emm$credential set logintimestamp = ?, lastlogintimestamp = ?, fingerprint = ?, fingerprintversion = ?, fingerprintkeygeneration  = ?, version = ? where id = ? and version = ?";
            Measurement measurement = this.statisticsService.startMeasurment("sql", sql, StatisticsService.MeasurementType.OUTGOING);
            try (Connection connection = this.dataSource.getReadWriteConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                int i = 1;
                preparedStatement.setObject(i++, (Object)CredentialDAOBean.getTimestamp((DateTime)credential.getLoginTimestamp()), 93, 9);
                if (credential.getLastLoginTimestamp() != null) {
                    preparedStatement.setObject(i++, (Object)CredentialDAOBean.getTimestamp((DateTime)credential.getLastLoginTimestamp()), 93, 9);
                } else {
                    preparedStatement.setNull(i++, 93);
                }
                i = this.assignFingerprint(preparedStatement, i, new Object[]{credential.getCredentialOwnerReferenceId(), credential.getCredentialTypeId(), credential.getHashedCredential(), credential.getCreated(), credential.getStatus().ordinal(), credential.getHashVersion().toInt(), credential.getLoginTimestamp(), credential.getLastLoginTimestamp(), credential.getFailedLogins(), credential.getLastFailedLogins(), credential.getLastFailedLoginTimestamp(), credential.getLastResetAttempt(), credential.getKeyGeneration(), credential.getSuspendedUntil()});
                preparedStatement.setLong(i++, currentVersion + 1L);
                preparedStatement.setLong(i++, credential.getId());
                preparedStatement.setLong(i++, currentVersion);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new PersistenceException("Error while saving Credential", e);
            }
            finally {
                this.statisticsService.stopMeasurement(measurement);
            }
        }
    }

    protected String getEntitySimpleName() {
        return Credential.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return CREDENTIAL_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 5;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getLong("fk_credentialownerreference"), resultSet.getLong("fk_credentialtype"), resultSet.getBytes("hashedpassword"), resultSet.getTimestamp("created"), resultSet.getInt(COL_STATUS), resultSet.getInt("hashversion"), resultSet.getTimestamp("logintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("logintimestamp").getTime()), resultSet.getTimestamp("lastlogintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("lastlogintimestamp").getTime()), resultSet.getInt("failedlogins"), resultSet.getInt("lastfailedlogins")};
        }
        if (fingerprintVersion == 2) {
            return new Object[]{resultSet.getLong("fk_credentialownerreference"), resultSet.getLong("fk_credentialtype"), resultSet.getBytes("hashedpassword"), resultSet.getTimestamp("created"), resultSet.getInt(COL_STATUS), resultSet.getInt("hashversion"), resultSet.getTimestamp("logintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("logintimestamp").getTime()), resultSet.getTimestamp("lastlogintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("lastlogintimestamp").getTime()), resultSet.getInt("failedlogins"), resultSet.getInt("lastfailedlogins"), resultSet.getInt("keygeneration")};
        }
        if (fingerprintVersion == 3) {
            return new Object[]{resultSet.getLong("fk_credentialownerreference"), resultSet.getLong("fk_credentialtype"), resultSet.getBytes("hashedpassword"), resultSet.getTimestamp("created"), resultSet.getInt(COL_STATUS), resultSet.getInt("hashversion"), resultSet.getTimestamp("logintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("logintimestamp").getTime()), resultSet.getTimestamp("lastlogintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("lastlogintimestamp").getTime()), resultSet.getInt("failedlogins"), resultSet.getInt("lastfailedlogins"), resultSet.getInt("keygeneration"), resultSet.getTimestamp(COL_SUSPENDED_UNTIL)};
        }
        if (fingerprintVersion == 4) {
            return new Object[]{resultSet.getLong("fk_credentialownerreference"), resultSet.getLong("fk_credentialtype"), resultSet.getBytes("hashedpassword"), resultSet.getTimestamp("created"), resultSet.getInt(COL_STATUS), resultSet.getInt("hashversion"), resultSet.getTimestamp("logintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("logintimestamp").getTime()), resultSet.getTimestamp("lastlogintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("lastlogintimestamp").getTime()), resultSet.getInt("failedlogins"), resultSet.getInt("lastfailedlogins"), resultSet.getTimestamp("lastfailedlogintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("lastfailedlogintimestamp").getTime()), resultSet.getInt("keygeneration"), resultSet.getTimestamp(COL_SUSPENDED_UNTIL)};
        }
        if (fingerprintVersion == 5) {
            return new Object[]{resultSet.getLong("fk_credentialownerreference"), resultSet.getLong("fk_credentialtype"), resultSet.getBytes("hashedpassword"), resultSet.getTimestamp("created"), resultSet.getInt(COL_STATUS), resultSet.getInt("hashversion"), resultSet.getTimestamp("logintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("logintimestamp").getTime()), resultSet.getTimestamp("lastlogintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("lastlogintimestamp").getTime()), resultSet.getInt("failedlogins"), resultSet.getInt("lastfailedlogins"), resultSet.getTimestamp("lastfailedlogintimestamp") == null ? null : new DateTime(resultSet.getTimestamp("lastfailedlogintimestamp").getTime()), resultSet.getTimestamp("lastresetattempt") == null ? null : new DateTime(resultSet.getTimestamp("lastresetattempt").getTime()), resultSet.getInt("keygeneration"), resultSet.getTimestamp(COL_SUSPENDED_UNTIL)};
        }
        return null;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getColumns() {
        return COLUMNS;
    }

    public String getSequenceName() {
        return "emm$credential_seq";
    }

    public String getTableName() {
        return "emm$credential";
    }

    public boolean isUpdatable() {
        return true;
    }

    public boolean isVersionable() {
        return true;
    }

    @Override
    public Credential findByCertificateHashAndCredentialType(CredentialType credentialType, byte[] credential) {
        return (Credential)this.find(this.getSelectStatement() + " where hashedpassword = ? and fk_credentialtype = ?", new Object[]{credential, credentialType.getId()});
    }

    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    public void processSuspendedUntil(DateTime now, SuspendedCredentialProcessor processor) {
        String query = "select c.*, nvl(ah.id,au.id) as ah_id, nvl(ah.msisdn,au.msisdn) as ah_msisdn, ah.effectivemsisdn as ah_effetive_msisdn, nvl(ah.email,au.email) as ah_email, ah.languagecode as ah_languagecode from " + this.getTableName() + " c left join emm$accountholder ah on(c.fk_credentialownerreference = ah.fk_credentialownerreference) left join emm$adminuser au on(c.fk_credentialownerreference = au.fk_credentialownerreference) where nvl(ah.id,au.id) is not null and c.status = ?";
        this.processEntityResultSet(query, processor, now);
    }

    private void processEntityResultSet(String statement, SuspendedCredentialProcessor processor, DateTime now) {
        Measurement measurement = this.statisticsService.startMeasurment("sql", statement, StatisticsService.MeasurementType.OUTGOING);
        try (Connection connection = this.dataSource.getReadOnlyConnection(this.getPreferredConnectionType());
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            this.assignParameters(preparedStatement, new Object[]{CredentialStatus.SUSPENDED.ordinal()});
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    Credential credential = this.createManagedEntity();
                    this.assign((BaseEntity)credential, resultSet);
                    if (credential.getSuspendedUntil() == null || !credential.getSuspendedUntil().isBefore(now)) continue;
                    SuspendedCredentialOwner owner = CredentialDAOBean.assign(resultSet);
                    processor.process(new SuspendedCredential(credential, owner));
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Error while processing: %s for status %s", new Object[]{statement, CredentialStatus.SUSPENDED}), e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    private static SuspendedCredentialOwner assign(ResultSet resultSet) throws SQLException {
        long ownerAccountHolderId = resultSet.getLong(PROCESSOR_AH_ID);
        String email = resultSet.getString(PROCESSOR_AH_EMAIL);
        String realMsisdn = resultSet.getString(PROCESSOR_AH_MSISDN);
        String effectiveMsisdn = resultSet.getString(PROCESSOR_AH_EFFETIVE_MSISDN);
        String languageCode = resultSet.getString(PROCESSOR_AH_LANGUAGECODE);
        return new SuspendedCredentialOwner(ownerAccountHolderId, email, realMsisdn, effectiveMsisdn, languageCode);
    }
}

