/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.credential.exception.CredentialErrorCode;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.persistence.DeepCloneable;
import jakarta.persistence.Entity;

@Entity
public class CredentialType
extends BaseEntity
implements DeepCloneable<CredentialType> {
    private static final long serialVersionUID = 8676548013303526639L;
    public static final String CREDENTIAL_TYPE_PASSWORD_NAME = "password";
    public static final String CREDENTIAL_TYPE_PINCODE_NAME = "pincode";
    public static final String CREDENTIAL_TYPE_CARD_PIN_NAME = "cardpin";
    private String name;
    private String description;

    public CredentialType() {
    }

    public CredentialType(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public CredentialType(CredentialType credentialType) {
        super((BaseEntity)credentialType);
        this.name = credentialType.getName();
        this.description = credentialType.getDescription();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public CredentialType deepClone() {
        return new CredentialType(this);
    }

    protected void validate() {
        if (this.getName() == null || this.getName().isEmpty()) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_TYPE_MISSING_NAME.getMessage());
        }
    }
}

