/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.notificationclient.NotificationChannelType;
import com.ericsson.em.emc.notificationclient.NotificationIdentity;
import java.io.Serializable;
import java.util.Optional;

public class SuspendedCredentialOwner
implements NotificationIdentity,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long ownerAccountHolderId;
    private final String email;
    private final String msisdn;
    private final String languageCode;

    private static String msisdn(String realMsisdn, String effectiveMsisdn) {
        return effectiveMsisdn == null ? realMsisdn : effectiveMsisdn;
    }

    public SuspendedCredentialOwner(long ownerAccountHolderId, String email, String realMsisdn, String effectiveMsisdn, String languageCode) {
        this.ownerAccountHolderId = ownerAccountHolderId;
        this.email = email;
        this.msisdn = SuspendedCredentialOwner.msisdn(realMsisdn, effectiveMsisdn);
        this.languageCode = languageCode;
    }

    public long getOwnerAccountHolderId() {
        return this.ownerAccountHolderId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    @Override
    public Optional<String> getNotificationReceiverIdentity(NotificationChannelType channelType) {
        switch (channelType) {
            case EMAIL: {
                return Optional.ofNullable(this.email);
            }
            case SMS: {
                return Optional.ofNullable(this.msisdn);
            }
        }
        return Optional.empty();
    }
}

