/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.csv;

import com.ericsson.em.emc.csv.CsvFileInfo;
import com.ericsson.em.validators.NotEmpty;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public final class RegistrationInfoCsvFileInfo
extends CsvFileInfo {
    @NotEmpty
    private final String registeredByIdentifier;
    @NotEmpty
    private final LocalDate fromDate;
    @NotEmpty
    private final LocalDate toDate;

    private RegistrationInfoCsvFileInfo(String fileNamePrefix, String registeredByIdentifier, LocalDate fromDate, LocalDate toDate) {
        super(fileNamePrefix);
        this.registeredByIdentifier = registeredByIdentifier;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    @Override
    public String generateFileName(String format, String fileExtension) {
        DateTimeFormatter dateFormat = DateTimeFormatter.ISO_LOCAL_DATE;
        return String.format(format, this.getFileNamePrefix(), this.registeredByIdentifier, dateFormat.format(this.fromDate), dateFormat.format(this.toDate), fileExtension);
    }

    public String getRegisteredByIdentifier() {
        return this.registeredByIdentifier;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    extends CsvFileInfo.Builder<RegistrationInfoCsvFileInfo, Builder> {
        private String registeredByIdentifier;
        private LocalDate fromDate;
        private LocalDate toDate;

        private Builder() {
        }

        @Override
        protected RegistrationInfoCsvFileInfo createCsvFileInfo(String fileNamePrefix) {
            return new RegistrationInfoCsvFileInfo(fileNamePrefix, this.registeredByIdentifier, this.fromDate, this.toDate);
        }

        public Builder registeredByIdentifier(String registeredByIdentifier) {
            this.registeredByIdentifier = registeredByIdentifier;
            return this;
        }

        public Builder fromDate(LocalDate fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public Builder toDate(LocalDate toDate) {
            this.toDate = toDate;
            return this;
        }
    }
}

