/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.entities;

import com.ericsson.em.emc.operations.otp.OtpOperations;
import com.ericsson.em.validation.Validation;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;

public final class OtpEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String identification;
    private final OtpOperations operationType;
    private final String operation;
    private final String otpTarget;
    private final String generatedBy;
    private final String generatedFor;

    public OtpOperations getOperationType() {
        return this.operationType;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getOtpTarget() {
        return this.otpTarget;
    }

    public String getGeneratedBy() {
        return this.generatedBy;
    }

    public String getGeneratedFor() {
        return this.generatedFor;
    }

    public String getIdentification() {
        return this.identification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtpEntity otpEntity = (OtpEntity)o;
        return Objects.equals(this.identification, otpEntity.identification) && this.operationType == otpEntity.operationType && Objects.equals(this.operation, otpEntity.operation) && Objects.equals(this.otpTarget, otpEntity.otpTarget) && Objects.equals(this.generatedBy, otpEntity.generatedBy) && Objects.equals(this.generatedFor, otpEntity.generatedFor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.operationType, this.operation, this.otpTarget, this.generatedBy, this.generatedFor});
    }

    public OtpEntity(Builder builder) {
        this.identification = builder.identification;
        this.operationType = builder.operationType;
        this.operation = builder.operation;
        this.otpTarget = builder.otpTarget;
        this.generatedBy = builder.generatedBy;
        this.generatedFor = builder.generatedFor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String identification;
        private OtpOperations operationType;
        private String operation;
        private String otpTarget;
        private String generatedBy;
        private String generatedFor;

        public Builder identification(String identification) {
            this.identification = identification;
            return this;
        }

        public Builder operationType(OtpOperations operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder otpTarget(String otpTarget) {
            this.otpTarget = otpTarget;
            return this;
        }

        public Builder generatedBy(String generatedBy) {
            this.generatedBy = generatedBy;
            return this;
        }

        public Builder generatedFor(String generatedFor) {
            this.generatedFor = generatedFor;
            return this;
        }

        public OtpEntity build() {
            return Validation.validate(new OtpEntity(this));
        }
    }
}

