/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.feature;

import com.ericsson.em.emc.feature.EnrichedFeature;
import com.ericsson.em.emc.feature.FeatureRemoteManager;
import com.ericsson.em.emc.feature.provider.PermissionFeatureService;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLog;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogContext;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogger;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.feature.Feature;
import jakarta.annotation.Resource;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Singleton
public class FeatureRemoteManagerBean
implements FeatureRemoteManager {
    @Resource
    private PermissionFeatureService permissionFeatureService;

    @Override
    @RolesAllowed(value={"ROLE_LICENSE_ADMIN"})
    @AuditTrailLog(transactionType="ActivateFeature", recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", recordVersion=1)
    public EnrichedFeature activate(Feature feature) throws ExecutionException {
        this.verify(feature);
        FeatureRemoteManagerBean.auditLog(feature);
        return this.enrich(this.permissionFeatureService.activate(feature));
    }

    @Override
    @RolesAllowed(value={"ROLE_LICENSE_ADMIN"})
    @AuditTrailLog(transactionType="DeactivateFeature", recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", recordVersion=1)
    public EnrichedFeature deactivate(Feature feature) throws ExecutionException {
        this.verify(feature);
        FeatureRemoteManagerBean.auditLog(feature);
        this.permissionFeatureService.deactivate(feature);
        return this.enrich(feature);
    }

    @Override
    @RolesAllowed(value={"ROLE_LICENSE_ADMIN"})
    @AuditTrailLog(transactionType="GetFeatures", recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", recordVersion=1)
    public List<EnrichedFeature> getFeatures() {
        return this.enrich(this.allFeatures());
    }

    @Override
    @RolesAllowed(value={"ROLE_LICENSE_ADMIN"})
    @AuditTrailLog(transactionType="GetPermissions", recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", recordVersion=1)
    public Set<String> getPermissions(Feature feature) throws ExecutionException {
        this.verify(feature);
        FeatureRemoteManagerBean.auditLog(feature);
        return this.permissionFeatureService.getPermissions(feature);
    }

    @Override
    @RolesAllowed(value={"ROLE_LICENSE_ADMIN", "ROLE_ADMIN", "ROLE_CONFIGURATION_ADMIN"})
    @AuditTrailLog(transactionType="GetFeatures", recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", recordVersion=1)
    public boolean isActive(Feature feature) {
        return this.permissionFeatureService.isActive(feature);
    }

    private List<Feature> allFeatures() {
        return this.permissionFeatureService.getFeatures();
    }

    private List<EnrichedFeature> enrich(List<Feature> features) {
        ArrayList<EnrichedFeature> result = new ArrayList<EnrichedFeature>(features.size());
        for (Feature feature : features) {
            result.add(this.enrich(feature));
        }
        return result;
    }

    private EnrichedFeature enrich(Feature feature) {
        boolean state = this.permissionFeatureService.isActive(feature);
        return new EnrichedFeature(feature, state);
    }

    private void verify(Feature feature) throws ExecutionException {
        if (!this.exists(feature)) {
            throw new ExecutionException(String.format("Feature '%s' does not exist.", feature.getName()));
        }
    }

    private boolean exists(Feature feature) {
        for (Feature current : this.allFeatures()) {
            if (!current.getName().equals(feature.getName())) continue;
            return true;
        }
        return false;
    }

    private static void auditLog(Feature feature) {
        AuditTrailLogger auditTrailLogger = AuditTrailLogContext.getLogger();
        if (auditTrailLogger.isLogEnable()) {
            auditTrailLogger.log("Feature", (Object)feature.getName());
        }
    }
}

