/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.feature.provider;

import com.ericsson.em.emc.feature.persistence.ActiveFeatureDAO;
import com.ericsson.em.emc.feature.persistence.FeatureEntity;
import com.ericsson.em.emc.feature.provider.DistributedPermissionHolder;
import com.ericsson.em.emc.feature.provider.DistributedPermissionHolderImpl;
import com.ericsson.em.emc.feature.provider.PermissionFactory;
import com.ericsson.em.emc.feature.provider.PermissionFeatureService;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cluster.ClusterException;
import com.ericsson.lwac.cluster.ClusterService;
import com.ericsson.lwac.crypto.securitymodule.persistence.SecurityModuleDAOService;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.deployer.BeanId;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.deployer.service.ServiceLifecycle;
import com.ericsson.lwac.deployer.service.ServiceStartException;
import com.ericsson.lwac.deployer.service.ServiceStopException;
import com.ericsson.lwac.feature.Feature;
import com.ericsson.lwac.feature.FeatureDefinition;
import com.ericsson.lwac.feature.FeatureSPI;
import com.ericsson.lwac.feature.FeatureService;
import com.ericsson.lwac.jobs.JobExecutorService;
import com.ericsson.lwac.logging.LogManager;
import com.ericsson.lwac.transaction.TransactionCommitException;
import com.ericsson.lwac.transaction.TransactionManager;
import com.ericsson.lwac.transaction.TransactionRollbackException;
import com.ericsson.lwac.transaction.UnstartedTransaction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Local;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Local(value={PermissionFeatureService.class})
@Service
public class PermissionFeatureServiceBean
implements PermissionFeatureService,
ServiceLifecycle,
FeatureSPI,
PermissionFactory {
    private static final Logger logger = LoggerFactory.getLogger(PermissionFeatureServiceBean.class);
    private final List<FeatureDefinition> features = new CopyOnWriteArrayList<FeatureDefinition>();
    private final Cache<FeatureDefinition, Boolean> featuresStatusCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();
    @Resource
    private SecurityModuleDAOService securityModuleDAOService;
    @Resource
    private FeatureService featureService;
    @Resource
    private JobExecutorService jobExecutorService;
    @EJB
    private ActiveFeatureDAO featureDAO;
    @Resource
    private ClusterService clusterService;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private TransactionManager transactionManager;
    @Resource
    private LogManager logManager;
    private volatile DistributedPermissionHolder holder;

    @PostConstruct
    private void postConstruct() throws ClusterException, IOException {
        this.featureService.register(this);
        BeanId beanId = this.applicationContext.getBeanId();
        this.holder = DistributedPermissionHolderImpl.create(beanId, this.clusterService, this, this.jobExecutorService, this.logManager);
    }

    @Override
    public void start() throws ServiceStartException {
        for (FeatureDefinition feature : this.features) {
            if (!feature.isDefaultActive()) continue;
            this.doActivate(feature);
        }
        try {
            this.holder.go();
        }
        catch (Exception e) {
            throw new ServiceStartException("Failed to Start", e);
        }
    }

    @Override
    public void stop() throws ServiceStopException {
    }

    @Override
    public void register(FeatureDefinition feature) {
        if (this.features.contains(feature)) {
            logger.error(String.format("Duplicate features detected '%s'", feature.getName()), new Exception());
        }
        this.features.add(feature);
    }

    @Override
    public Feature activate(Feature feature) throws ExecutionException {
        try {
            boolean wasActive = this.transactionManager.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> this.doActivate(feature));
            if (wasActive) {
                throw new ExecutionException(String.format("Feature '%s' is already active.", feature.getName()));
            }
        }
        catch (TransactionCommitException | TransactionRollbackException e) {
            logger.warn("Activate failed", e);
        }
        finally {
            this.refresh();
        }
        return feature;
    }

    @Override
    public Feature deactivate(Feature feature) throws ExecutionException {
        if (this.define(feature).isDefaultActive()) {
            throw new ExecutionException(String.format("Feature '%s' can not be deactivated.", feature.getName()));
        }
        if (!this.isActive(feature)) {
            throw new ExecutionException(String.format("Feature '%s' is already inactive.", feature.getName()));
        }
        try {
            this.transactionManager.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> {
                this.doDeactivate(feature);
                return null;
            });
        }
        catch (TransactionCommitException | TransactionRollbackException e) {
            logger.warn("Deactivate failed", e);
        }
        finally {
            this.refresh();
        }
        return feature;
    }

    private void doDeactivate(Feature feature) {
        FeatureDefinition definition = this.define(feature);
        if (definition != null && !definition.isDefaultActive()) {
            this.featureDAO.delete(new FeatureEntity(feature));
        }
    }

    private boolean doActivate(Feature feature) {
        boolean wasActive = this.isActive(feature);
        if (this.featureDAO.find(feature) == null) {
            this.featureDAO.create(new FeatureEntity(feature));
        }
        return wasActive;
    }

    private FeatureDefinition define(Feature feature) {
        for (FeatureDefinition current : this.features) {
            if (!current.getName().equals(feature.getName())) continue;
            return current;
        }
        logger.error(String.format("Feature %s was not found.", feature.getName()), new Exception());
        return null;
    }

    @Override
    public boolean isActive(String permission) {
        return this.holder.getPermissions().contains(permission);
    }

    @Override
    public Set<String> getPermissions() {
        return this.holder.getPermissions();
    }

    @Override
    public Set<String> getPermissions(String group) {
        HashSet<String> result = new HashSet<String>();
        for (FeatureDefinition fd : this.features) {
            Set<String> groupedPermissions;
            if (!this.isActive(fd) || (groupedPermissions = fd.getPermissions(group)) == null) continue;
            result.addAll(groupedPermissions);
        }
        return result;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public boolean isActive(Feature feature) {
        FeatureDefinition featureDefinition = this.define(feature);
        if (featureDefinition == null) {
            return false;
        }
        if (featureDefinition.isDefaultActive()) {
            return true;
        }
        Boolean currentStatus = this.featuresStatusCache.getIfPresent(featureDefinition);
        if (currentStatus == null) {
            FeatureEntity entity = this.featureDAO.find(feature);
            boolean newStatus = entity != null;
            this.featuresStatusCache.put(featureDefinition, newStatus);
            return newStatus;
        }
        return currentStatus;
    }

    @Override
    public Set<String> getPermissions(Feature feature) {
        return this.define(feature).getPermissions();
    }

    @Override
    public void fill(Set<String> permissions) {
        this.featuresStatusCache.invalidateAll();
        for (FeatureDefinition feature : this.features) {
            if (!this.isActive(feature)) continue;
            permissions.addAll(feature.getPermissions());
        }
    }

    @VisibleForTesting
    public void resetCache() {
        this.featuresStatusCache.invalidateAll();
    }

    private void refresh() {
        this.featuresStatusCache.invalidateAll();
        try {
            this.holder.refresh();
        }
        catch (Exception e) {
            logger.error("Failed to refresh features", e);
        }
    }

    @Override
    public List<String> getInactivePermissions() {
        ArrayList<String> permissions = new ArrayList<String>();
        for (FeatureDefinition feature : this.features) {
            permissions.addAll(feature.getPermissions());
        }
        permissions.removeAll(this.featureService.getPermissions());
        return permissions;
    }
}

