/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.financial;

import com.ericsson.em.emc.IllegalFriException;
import com.ericsson.em.emc.financial.FRI;
import com.ericsson.em.emc.financial.FriBuilder;
import com.ericsson.em.emc.financial.FriBuilderCreator;
import com.ericsson.em.emc.financial.FriTypeRegister;
import com.ericsson.em.emc.financial.UnknownTypeFriBuilder;
import com.google.common.base.Strings;
import jakarta.ejb.Singleton;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class FriTypeRegisterBean
implements FriTypeRegister {
    private final Map<String, FriBuilderCreator> friBuilderCreators = new ConcurrentHashMap<String, FriBuilderCreator>();

    @Override
    public void register(String friType, FriBuilderCreator friBuilderCreator) {
        if (this.friBuilderCreators.containsKey(friType.toUpperCase())) {
            throw new IllegalStateException("FRI type register already has FRI builder creator for FRI type " + friType);
        }
        this.friBuilderCreators.put(friType.toUpperCase(), friBuilderCreator);
    }

    @Override
    public FriBuilder createFriBuilder(FRI fri) {
        if (fri == null) {
            throw new IllegalFriException("Missing FRI");
        }
        return this.createFriBuilder(fri.getType()).withId(fri.getId()).withHandler(fri.getHandler());
    }

    @Override
    public boolean isRegistered(String friType) {
        return this.friBuilderCreators.containsKey(friType.toUpperCase());
    }

    @Override
    public Set<String> getRegisteredFriTypes() {
        return this.friBuilderCreators.keySet();
    }

    @Override
    public FriBuilder createFriBuilder(String fri) {
        if (Strings.isNullOrEmpty(fri)) {
            throw new IllegalFriException("Missing FRI string");
        }
        if (fri.toUpperCase().startsWith("FRI:")) {
            return this.createFriBuilderFromString(fri);
        }
        return this.createFriBuilderOfType(fri);
    }

    private FriBuilder createFriBuilderFromString(String fri) {
        String[] splitFri = fri.split("/");
        if (splitFri.length != 2) {
            throw new IllegalFriException("Can not match FRI");
        }
        FriBuilder friBuilder = this.createFriBuilderOfType(splitFri[1]);
        return friBuilder.withId(splitFri[0].substring(4));
    }

    private FriBuilder createFriBuilderOfType(String friType) {
        FriBuilderCreator friBuilderCreator;
        String type = friType;
        String controlKey = null;
        if (friType.contains("ctrlkey")) {
            String[] splitType = friType.split("\\?");
            type = splitType[0];
            controlKey = splitType[1].substring(8);
        }
        if ((friBuilderCreator = this.friBuilderCreators.get(type.toUpperCase())) == null) {
            return new UnknownTypeFriBuilder(friType);
        }
        return friBuilderCreator.create().withControlKey(controlKey);
    }
}

