/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;

public abstract class HierarchyUtil {
    public static ProfileService findService(ProfileService profileService, String name) {
        if (profileService.getName().equals(name)) {
            return profileService;
        }
        for (ProfileService childService : profileService.getChildren()) {
            ProfileService result = HierarchyUtil.findService(childService, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static ProfileService findService(ProfileReference profileReference, String name) {
        return HierarchyUtil.findService(profileReference.getProfile(), name);
    }

    public static ProfileService findService(Profile profile, String name) {
        ProfileService result = null;
        if (profile != null) {
            for (ProfileService profileService : profile.getServices()) {
                result = HierarchyUtil.findService(profileService, name);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static String findProperty(ProfileReference profileReference, String serviceName, String propertyName) {
        return HierarchyUtil.findProperty(profileReference.getProfile(), serviceName, propertyName);
    }

    public static String findProperty(Profile profile, String serviceName, String propertyName) {
        ProfileService profileService = HierarchyUtil.findService(profile, serviceName);
        String value = null;
        if (profileService != null) {
            value = profileService.getPropertyValue(propertyName);
        }
        return value;
    }

    public static boolean contains(ProfileService profileService, CounterConfiguration counterConfiguration) {
        for (CounterConfiguration counterConfiguration2 : profileService.getIndividualCounterConfigurations()) {
            if (!counterConfiguration2.equals(counterConfiguration)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(ProfileService profileService, ThresholdConfiguration thresholdConfiguration) {
        for (ThresholdConfiguration candidate : profileService.getThresholdConfigurations()) {
            if (!candidate.equals(thresholdConfiguration)) continue;
            return true;
        }
        return false;
    }
}

