/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.ericsson.em.emc.hierarchies.cli.SharedCounterConfigurationCliManager;
import com.ericsson.em.validators.IsCounterName;
import com.ericsson.em.validators.IsFilesystemPath;
import com.ericsson.em.validators.Length;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cli.RemoteCLIEnvironment;
import com.ericsson.lwac.cli.commands.Command;
import com.ericsson.lwac.cli.commands.RemoteAction;
import com.ericsson.lwac.cli.commands.RemoteCommand;
import com.ericsson.lwac.utilities.cli.table.CLIHeaders;
import com.ericsson.lwac.utilities.cli.table.CLITable;
import jakarta.ejb.EJB;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;

@Command(name="sharedcounterconfiguration", group="common")
@Parameters(separators="=")
@RemoteCommand
public class SharedCounterCliTask {
    private static final int BUFFER_SIZE = 16384;
    @EJB
    private SharedCounterConfigurationCliManager sharedCounterConfigurationCliManager;

    private String readFile(File file) throws IOException {
        List<String> allLines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        for (String string : allLines) {
            builder.append(string);
        }
        return builder.toString();
    }

    private String readConsole(RemoteCLIEnvironment cliEnvironment) throws IOException {
        StringBuilder out = new StringBuilder();
        try (InputStream inputStream = System.in;
             InputStreamReader input = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            int read;
            cliEnvironment.getOutputWriter().println("Paste shared counter config content. Ctrl D to exit.");
            char[] buffer = new char[16384];
            while ((read = ((Reader)input).read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, read);
            }
        }
        return out.toString();
    }

    @Command(name="list")
    @Parameters(separators="=", commandDescription="Lists all shared counter configuration in system.")
    private class SharedCounterListAction
    implements RemoteAction {
        private SharedCounterListAction() {
        }

        @Override
        public void execute(RemoteCLIEnvironment cliEnvironment) throws ExecutionException {
            try {
                CLITable.Builder table = CLITable.create().name("Shared counter configurations").header(new CLIHeaders("Name"));
                SharedCounterCliTask.this.sharedCounterConfigurationCliManager.getSharedCounterConfigurationNames().forEach(name -> table.row((String)name));
                cliEnvironment.getOutputWriter().println(table.build());
            }
            catch (Exception e) {
                cliEnvironment.getOutputWriter().println("Failed to list, " + e.getMessage());
            }
        }
    }

    @Command(name="update")
    @Parameters(separators="=", commandDescription="Update a shared counter configuration.")
    private class SharedCounterUpdateAction
    implements RemoteAction {
        @Parameter(description="The path to shared counter config file to import and update.", names={"-i", "--importfile"}, required=true)
        @IsFilesystemPath
        private String configFilePath;
        @Length(min=1, max=64)
        @IsCounterName
        @Parameter(description="The unique name of the shared counter configuration to update.", names={"-n", "--name"}, required=true)
        private String name;
        @Parameter(description="Bypass validation by running in permissive mode. This may lead to faulty shared counters.", names={"--permissive-mode"})
        private boolean permissiveMode = false;

        private SharedCounterUpdateAction() {
        }

        @Override
        public void execute(RemoteCLIEnvironment cliEnvironment) throws ExecutionException {
            try {
                File configFile = new File(this.configFilePath);
                if (configFile.exists()) {
                    String serializedConfigContent = SharedCounterCliTask.this.readFile(configFile);
                    SharedCounterCliTask.this.sharedCounterConfigurationCliManager.updateSharedCounterConfiguration(serializedConfigContent, this.name, this.permissiveMode);
                    cliEnvironment.getOutputWriter().println("Successfully updated shared counter configuration");
                } else {
                    cliEnvironment.getOutputWriter().println("Failed to update, file does not exist");
                }
            }
            catch (Exception e) {
                cliEnvironment.getOutputWriter().println("Failed to update, " + e.getMessage());
            }
        }
    }

    @Command(name="export")
    @Parameters(separators="=", commandDescription="Export a shared counter configuration.")
    private class SharedCounterExportAction
    implements RemoteAction {
        @Parameter(description="The filepath to export shared counter config to.", names={"-o", "--outputfile"})
        @IsFilesystemPath
        private String outputFile;
        @Length(min=1, max=64)
        @IsCounterName
        @Parameter(description="The unique name of the shared counter configuration to export.", names={"-n", "--name"}, required=true)
        private String name;

        private SharedCounterExportAction() {
        }

        @Override
        public void execute(RemoteCLIEnvironment cliEnvironment) throws ExecutionException {
            block9: {
                try {
                    String serialized = SharedCounterCliTask.this.sharedCounterConfigurationCliManager.exportSharedCounterConfiguration(this.name);
                    if (this.outputFile != null) {
                        FileOutputStream outputStream = new FileOutputStream(this.outputFile);
                        try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
                            output.write(serialized);
                        }
                        cliEnvironment.getOutputWriter().println("Successfully exported to file.");
                        break block9;
                    }
                    cliEnvironment.getOutputWriter().println(serialized);
                }
                catch (Exception e) {
                    cliEnvironment.getOutputWriter().println("Failed to export, " + e.getMessage());
                }
            }
        }
    }

    @Command(name="import")
    @Parameters(separators="=", commandDescription="Create a shared counter configuration given a json content.")
    private class SharedCounterCreateAction
    implements RemoteAction {
        @Parameter(description="The path to shared counter config file to import.", names={"-i", "--importfile"})
        @IsFilesystemPath
        private String configFilePath;
        @Length(min=1, max=64)
        @IsCounterName
        @Parameter(description="The unique name of the new shared counter configuration. Will override name from import file.", names={"-n", "--name"})
        private String name;
        @Parameter(description="Bypass validation by running in permissive mode. This may lead to faulty shared counters.", names={"--permissive-mode"})
        private boolean permissiveMode = false;

        private SharedCounterCreateAction() {
        }

        @Override
        public void execute(RemoteCLIEnvironment cliEnvironment) throws ExecutionException {
            try {
                String serializedConfigContent = "";
                if (this.configFilePath == null) {
                    serializedConfigContent = SharedCounterCliTask.this.readConsole(cliEnvironment);
                } else {
                    File configFile = new File(this.configFilePath);
                    if (configFile.exists()) {
                        serializedConfigContent = SharedCounterCliTask.this.readFile(configFile);
                    } else {
                        cliEnvironment.getOutputWriter().println("Failed to create, file does not exist");
                        return;
                    }
                }
                if (serializedConfigContent.isEmpty()) {
                    cliEnvironment.getOutputWriter().println("Failed to create, empty JSON contents!");
                } else {
                    String newName = SharedCounterCliTask.this.sharedCounterConfigurationCliManager.createSharedCounterConfiguration(serializedConfigContent, this.name, this.permissiveMode);
                    cliEnvironment.getOutputWriter().println(newName + " successfully created.");
                }
            }
            catch (Exception e) {
                cliEnvironment.getOutputWriter().println("Failed to create, " + e.getMessage());
            }
        }
    }
}

