/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters;

import com.ericsson.em.emc.hierarchies.counters.CounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.CounterIdentifierMatchParameters;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.google.common.base.Strings;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@Singleton
public class CounterConfigurationManagerBean
implements CounterConfigurationManager {
    @EJB
    private IndividualCounterConfigurationManager individualCounterConfigurationManager;

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public Set<String> getAllMatchingCounterIdentifiers(CounterIdentifierMatchParameters params) {
        List<IndividualCounterConfiguration> counterConfigurationList = this.individualCounterConfigurationManager.findByMatchingAttributes(params);
        TreeSet<String> result = new TreeSet<String>();
        counterConfigurationList.stream().map(IndividualCounterConfiguration::getIdentifier).filter(id -> !Strings.isNullOrEmpty(id)).forEach(result::add);
        return result;
    }

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public boolean isIdentifierPresent(String identifier) {
        return !this.individualCounterConfigurationManager.findByIdentifier(identifier).isEmpty();
    }

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public boolean isIdentifierValidForAttributes(CounterIdentifierMatchParameters validatorParams) {
        return this.individualCounterConfigurationManager.isIdentifierValidFor(validatorParams);
    }
}

