/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters;

import java.util.Optional;

public class CounterTransaction {
    private Long id;
    private int numberOfReservations;
    private Long subTransactionId;
    private boolean hasChangedAfterSubTransaction;

    public CounterTransaction() {
        this.id = null;
        this.numberOfReservations = 0;
        this.subTransactionId = null;
        this.hasChangedAfterSubTransaction = false;
    }

    public CounterTransaction(Long id) {
        this.id = id;
        this.numberOfReservations = 0;
        this.subTransactionId = null;
        this.hasChangedAfterSubTransaction = false;
    }

    public CounterTransaction(CounterTransaction other) {
        this.id = other.id;
        this.numberOfReservations = other.numberOfReservations;
        this.subTransactionId = null;
        this.hasChangedAfterSubTransaction = false;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void increaseNumberOfReservations() {
        if (this.subTransactionId != null) {
            this.hasChangedAfterSubTransaction = true;
        }
        ++this.numberOfReservations;
    }

    public int getNumberOfReservations() {
        return this.numberOfReservations;
    }

    public boolean isSubTransactionCreated() {
        return this.subTransactionId != null;
    }

    public void setSubTransactionId(Long id) {
        this.subTransactionId = id;
    }

    public Optional<Long> getSubTransactionId() {
        return Optional.ofNullable(this.subTransactionId);
    }

    public boolean hasChangedAfterSubTransaction() {
        return this.hasChangedAfterSubTransaction;
    }
}

