/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.limits;

import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.limits.LimitMatcher;
import com.ericsson.em.emc.hierarchies.limits.LimitMatchingParameters;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import org.joda.time.DateTime;

public final class CounterMatcher {
    private CounterMatcher() {
    }

    public static boolean isMatching(CounterConfiguration configuration, LimitMatchingParameters matchingParameters, DateTime dateTime) {
        if (!configuration.within(dateTime)) {
            return false;
        }
        if (matchingParameters.shallMatchOnUnit() && !CounterMatcher.hasMatchingUnit(configuration, matchingParameters.getUnit())) {
            return false;
        }
        if (matchingParameters.shallMatchOnType() && !CounterMatcher.hasMatchingCounterType(configuration, matchingParameters)) {
            return false;
        }
        if (matchingParameters.shallMatchOnName() && !CounterMatcher.hasMatchingConfigurationName(configuration, matchingParameters)) {
            return false;
        }
        return LimitMatcher.isMatching(configuration.getMatchRules(), matchingParameters);
    }

    private static boolean hasMatchingUnit(CounterConfiguration configuration, Unit unit) {
        return configuration.hasMatchingUnit(unit);
    }

    private static boolean hasMatchingCounterType(CounterConfiguration configuration, LimitMatchingParameters matchingParameters) {
        return configuration.getCounterType().getName().equals(matchingParameters.getType());
    }

    private static boolean hasMatchingConfigurationName(CounterConfiguration configuration, LimitMatchingParameters matchingParameters) {
        return configuration.getName().equals(matchingParameters.getName());
    }
}

