/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceReservation;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceReservationDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.partition.CleanupPartitionDataProvider;
import com.ericsson.lwac.database.partition.CleanupPartitionService;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import com.ericsson.lwac.database.persistence.ResultSetProcessor;
import com.ericsson.lwac.database.persistence.sequence.SequenceHelper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

@Singleton
@Updatable
@Validatable
@CryptoKeys(keyAliases={"hier.counterbalreserv.S"})
public class CounterBalanceReservationDAOBean
extends CryptoExtendedBaseEntityDAOBean<CounterBalanceReservation>
implements CounterBalanceReservationDAO {
    @Resource
    private CleanupPartitionService cleanupPartitionService;
    @EJB
    private SequenceHelper sequenceHelper;
    private static final String TABLE_NAME = "hier$counterbalreserv";
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    static final String FINGERPRINT_KEY = "hier.counterbalreserv.S";
    private static final String MULTIPLE_STATUSES_TO_KEEP = " in ('%s')";
    private static final String SINGLE_STATUS_TO_KEEP = " = '%s'";
    private static final String PARTITION_UPDATE_CLAUSE = " and " + String.valueOf((Object)TableColumn.COUNTER_TRANSACTION_ID) + " = ? ";
    private final List<CounterBalanceReservation.Status> statusesToKeepOnCleanup = List.of(CounterBalanceReservation.Status.ACTIVE);

    @Override
    public CounterBalanceReservation create(CounterBalanceReservation counterBalanceReservation) {
        return (CounterBalanceReservation)super.create((BaseEntity)counterBalanceReservation);
    }

    @Override
    public List<CounterBalanceReservation> findActiveReservationsForTransaction(Long counterTransactionId) {
        return this.findMultiple(this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.COUNTER_TRANSACTION_ID) + " = ? and " + String.valueOf((Object)TableColumn.STATUS) + " = ? order by " + String.valueOf((Object)TableColumn.ID), new Object[]{counterTransactionId, CounterBalanceReservation.Status.ACTIVE.toString()});
    }

    @Override
    public List<CounterBalanceReservation> findActiveReservationsForCounterBalanceId(Long counterBalanceId) {
        return this.findMultiple(this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FK_COUNTER_BALANCE) + " = ? and " + String.valueOf((Object)TableColumn.STATUS) + " = ? order by " + String.valueOf((Object)TableColumn.ID), new Object[]{counterBalanceId, CounterBalanceReservation.Status.ACTIVE.toString()});
    }

    @Override
    public List<CounterBalanceReservation.Status> getStatusesToKeep() {
        return this.statusesToKeepOnCleanup;
    }

    @Override
    public CounterBalanceReservation updateCounterBalanceReservation(CounterBalanceReservation counterBalanceReservation) {
        return (CounterBalanceReservation)super.updateWithExtendedWhereClause((BaseEntity)counterBalanceReservation, PARTITION_UPDATE_CLAUSE, new Object[]{counterBalanceReservation.getCounterTransactionId()});
    }

    public CounterBalanceReservation update(CounterBalanceReservation counterBalanceReservation) {
        return (CounterBalanceReservation)super.updateWithExtendedWhereClause((BaseEntity)counterBalanceReservation, PARTITION_UPDATE_CLAUSE, new Object[]{counterBalanceReservation.getCounterTransactionId()});
    }

    public CounterBalanceReservation updateDefaultFingerprint(CounterBalanceReservation entry) {
        return (CounterBalanceReservation)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FINGERPRINT_VERSION) + "= ? order by " + String.valueOf((Object)TableColumn.ID) + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        CounterBalanceReservation counterBalanceReservation = (CounterBalanceReservation)baseEntity;
        Timestamp initTimestamp = counterBalanceReservation.getInitTimestamp() != null ? CounterBalanceReservationDAOBean.getTimestamp((DateTime)counterBalanceReservation.getInitTimestamp()) : null;
        CounterBalanceReservationDAOBean.setNullableDateTimeAsTimestamp((int)TableColumn.CREATED_TIME.index(), (DateTime)counterBalanceReservation.getCreatedTime(), (PreparedStatement)preparedStatement);
        preparedStatement.setLong(TableColumn.COUNTER_TRANSACTION_ID.index(), counterBalanceReservation.getCounterTransactionId());
        preparedStatement.setLong(TableColumn.FK_COUNTER_BALANCE.index(), counterBalanceReservation.getCounterBalanceId());
        preparedStatement.setBigDecimal(TableColumn.AMOUNT.index(), counterBalanceReservation.getAmount());
        preparedStatement.setString(TableColumn.STATUS.index(), counterBalanceReservation.getStatus().toString());
        preparedStatement.setObject(TableColumn.INIT_TIMESTAMP.index(), (Object)initTimestamp, 93, 9);
        return this.assignFingerprint(preparedStatement, TableColumn.FINGERPRINT.index(), new Object[]{counterBalanceReservation.getCreatedTime() != null ? CounterBalanceReservationDAOBean.getTimestamp((DateTime)counterBalanceReservation.getCreatedTime()) : null, counterBalanceReservation.getCounterTransactionId(), counterBalanceReservation.getCounterBalanceId(), counterBalanceReservation.getAmount(), counterBalanceReservation.getStatus().toString(), initTimestamp});
    }

    public void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        CounterBalanceReservation counterBalanceReservation = (CounterBalanceReservation)baseEntity;
        counterBalanceReservation.setCreatedTime(CounterBalanceReservationDAOBean.getNullableDateTimeFromTimestampResultSet((ResultSet)resultSet, (String)TableColumn.CREATED_TIME.toString()));
        counterBalanceReservation.setCounterTransactionId(resultSet.getLong(TableColumn.COUNTER_TRANSACTION_ID.toString()));
        counterBalanceReservation.setCounterBalanceId(resultSet.getLong(TableColumn.FK_COUNTER_BALANCE.toString()));
        counterBalanceReservation.setAmount(resultSet.getBigDecimal(TableColumn.AMOUNT.toString()));
        counterBalanceReservation.setStatus(CounterBalanceReservation.Status.valueOf(resultSet.getString(TableColumn.STATUS.toString())));
        Timestamp initTime = resultSet.getTimestamp(TableColumn.INIT_TIMESTAMP.toString());
        counterBalanceReservation.setInitTimestamp(initTime != null ? new DateTime(initTime.getTime()) : null);
    }

    public CounterBalanceReservation createManagedEntity() {
        return new CounterBalanceReservation();
    }

    public String[] getColumns() {
        return CounterBalanceReservationDAOBean.getColumnNames(TableColumn.class);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return "hier$counterbalreserv_seq";
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    @Override
    public Long createCounterBalanceTransaction() {
        return this.sequenceHelper.getNextValue("hier$counter_transactionid");
    }

    @PostConstruct
    public void postConstruct() {
        this.cleanupPartitionService.registerCleanupPartitionDataProvider(new CleanupPartitionDataProvider(){

            public String getTableNameForCleanup() {
                return CounterBalanceReservationDAOBean.this.getTableName();
            }

            public String getKeepDataCondition() {
                String statusesToKeepListString = CounterBalanceReservationDAOBean.this.statusesToKeepOnCleanup.stream().map(Enum::toString).collect(Collectors.joining("','"));
                String condition = CounterBalanceReservationDAOBean.this.statusesToKeepOnCleanup.size() > 1 ? CounterBalanceReservationDAOBean.MULTIPLE_STATUSES_TO_KEEP : CounterBalanceReservationDAOBean.SINGLE_STATUS_TO_KEEP;
                return String.valueOf((Object)TableColumn.STATUS) + String.format(condition, statusesToKeepListString);
            }
        });
    }

    protected String getEntitySimpleName() {
        return CounterBalanceReservation.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getTimestamp(TableColumn.CREATED_TIME.toString()), resultSet.getLong(TableColumn.COUNTER_TRANSACTION_ID.toString()), resultSet.getLong(TableColumn.FK_COUNTER_BALANCE.toString()), resultSet.getBigDecimal(TableColumn.AMOUNT.toString()), resultSet.getString(TableColumn.STATUS.toString()), resultSet.getTimestamp(TableColumn.INIT_TIMESTAMP.toString())};
        }
        return null;
    }

    @Override
    public void processActiveReservations(ResultSetProcessor resultSetProcessor, DateTime fromDate, DateTime toDate) {
        String statement = "select " + String.valueOf((Object)TableColumn.COUNTER_TRANSACTION_ID) + " from hier$counterbalreserv where " + String.valueOf((Object)TableColumn.STATUS) + " = '" + CounterBalanceReservation.Status.ACTIVE.toString() + "' and " + String.valueOf((Object)TableColumn.CREATED_TIME) + " between ? and ? ";
        this.processResultSet(statement, TableColumn.COUNTER_TRANSACTION_ID.toString(), resultSetProcessor, new Object[]{CounterBalanceReservationDAOBean.getTimestamp((DateTime)fromDate), CounterBalanceReservationDAOBean.getTimestamp((DateTime)toDate)});
    }

    private static enum TableColumn {
        ID("id"),
        CREATED_TIME("createdtime"),
        COUNTER_TRANSACTION_ID("countertransactionid"),
        FK_COUNTER_BALANCE("fk_counterbalance"),
        AMOUNT("amount"),
        STATUS("status"),
        INIT_TIMESTAMP("inittimestamp"),
        FINGERPRINT("fingerprint"),
        FINGERPRINT_VERSION("fingerprintversion"),
        FINGERPRINT_KEY_GENERATION("fingerprintkeygeneration");

        private final String value;

        int index() {
            return this.ordinal();
        }

        private TableColumn(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

