/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.limits.LegacyLimitsConverter;
import com.ericsson.em.emc.hierarchies.limits.RatingCounterType;
import com.ericsson.em.emc.hierarchies.persistence.CounterMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.Periodizable;
import com.ericsson.em.emc.hierarchies.persistence.serialization.UnknownFieldAware;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@Entity
public abstract class CounterConfiguration
extends Periodizable
implements Serializable,
UnknownFieldAware {
    protected String name;
    private String description;
    private String externalId;
    private CounterType counterType = NoCounterType.NONE;
    private List<CounterMatchRule> matchRules = new LinkedList<CounterMatchRule>();
    private String unit;
    private BigDecimal defaultValue = BigDecimal.ZERO;
    private DynamicType dynamicType = DynamicType.NOT_DYNAMIC;
    private int dynamicLength;
    private List<ModifierConfiguration> modifierConfigurations = new LinkedList<ModifierConfiguration>();
    private boolean hardLimitNotificationsEnabled;
    private String hardLimitNotificationOperationTypeName;
    private boolean personalizedLimitAllowed = false;

    public abstract CounterConfigurationType getCounterConfigurationType();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CounterConfiguration() {
    }

    public CounterConfiguration(String name) {
        this.name = name;
    }

    CounterConfiguration(CounterConfiguration counterConfiguration) {
        super(counterConfiguration);
        this.name = counterConfiguration.name;
        this.counterType = counterConfiguration.counterType;
        this.externalId = counterConfiguration.externalId;
        this.dynamicType = counterConfiguration.dynamicType;
        this.dynamicLength = counterConfiguration.dynamicLength;
        for (ModifierConfiguration modifierConfiguration : counterConfiguration.modifierConfigurations) {
            ModifierConfiguration clone = modifierConfiguration.deepClone();
            clone.setCounterConfiguration(this);
            this.modifierConfigurations.add(clone);
        }
        counterConfiguration.matchRules.stream().map(o -> new CounterMatchRule((CounterMatchRule)o, this)).forEach(this.matchRules::add);
        this.hardLimitNotificationsEnabled = counterConfiguration.hardLimitNotificationsEnabled;
        this.hardLimitNotificationOperationTypeName = counterConfiguration.hardLimitNotificationOperationTypeName;
        this.description = counterConfiguration.description;
        this.unit = counterConfiguration.unit;
        this.defaultValue = counterConfiguration.defaultValue;
        this.personalizedLimitAllowed = counterConfiguration.personalizedLimitAllowed;
    }

    @Column(unique=true, nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CounterType getCounterType() {
        return this.counterType;
    }

    public void setCounterType(CounterType counterType) {
        this.counterType = counterType;
    }

    @Deprecated
    public String getUnitType() {
        String legacyName = this.counterType.getLegacyName();
        return this.matchRules.stream().map(cmr -> cmr.getOperationType() + (String)(Strings.isNullOrEmpty(legacyName) ? "" : "_" + legacyName)).collect(Collectors.joining(","));
    }

    public int getDynamicLength() {
        return this.dynamicLength;
    }

    public void setDynamicLength(int dynamicLength) {
        this.dynamicLength = dynamicLength;
    }

    public DynamicType getDynamicType() {
        return this.dynamicType;
    }

    public void setDynamicType(DynamicType dynamicType) {
        this.dynamicType = dynamicType;
    }

    public List<ModifierConfiguration> getModifierConfigurations() {
        return this.modifierConfigurations;
    }

    public void setModifierConfigurations(List<ModifierConfiguration> modifierConfigurations) {
        this.modifierConfigurations = modifierConfigurations;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public boolean isHardLimitNotificationsEnabled() {
        return this.hardLimitNotificationsEnabled;
    }

    public void setHardLimitNotificationsEnabled(boolean hardLimitNotificationsEnabled) {
        this.hardLimitNotificationsEnabled = hardLimitNotificationsEnabled;
    }

    public String getHardLimitNotificationOperationTypeName() {
        return this.hardLimitNotificationOperationTypeName;
    }

    public void setHardLimitNotificationOperationTypeName(String hardLimitNotificationOperationTypeName) {
        this.hardLimitNotificationOperationTypeName = hardLimitNotificationOperationTypeName;
    }

    public boolean isPersonalizedLimitAllowed() {
        return this.personalizedLimitAllowed;
    }

    public void setPersonalizedLimitAllowed(boolean personalizedLimitAllowed) {
        this.personalizedLimitAllowed = personalizedLimitAllowed;
    }

    public boolean hasUnit() {
        return this.unit != null;
    }

    public Unit getUnit() {
        return Unit.fromString(this.unit);
    }

    public void setUnit(Unit unit) {
        Preconditions.checkNotNull(unit);
        this.unit = unit.isEmpty() ? null : unit.getValue();
    }

    public BigDecimal getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(BigDecimal defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<CounterMatchRule> getMatchRules() {
        return this.matchRules;
    }

    public void setMatchRules(List<CounterMatchRule> matchRules) {
        this.matchRules = Preconditions.checkNotNull(matchRules);
    }

    public String toString() {
        return CounterConfiguration.class.getSimpleName() + "[id=" + this.mId + "]";
    }

    @Override
    public void validate() {
        super.validate();
    }

    public boolean isSimilarTo(CounterConfiguration other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.isRatingCounter()) {
            return false;
        }
        if (!this.getUnit().equals(other.getUnit())) {
            return false;
        }
        for (CounterMatchRule cmr : this.matchRules) {
            if (other.matchRules.stream().filter(cmr::equalsToIgnoreId).findAny().isPresent()) continue;
            return false;
        }
        if (this.isLoginCounter()) {
            return true;
        }
        if (this.modifierConfigurations != null && other.modifierConfigurations != null) {
            for (ModifierConfiguration md1 : this.modifierConfigurations) {
                if (other.modifierConfigurations.stream().filter(md1::isSimilarTo).findAny().isPresent()) continue;
                return false;
            }
        }
        return this.periodType == other.periodType;
    }

    private boolean isLoginCounter() {
        if (this.matchRules.size() == 1) {
            String transferType = this.matchRules.get(0).getOperationType();
            return "password_auth_failed".equals(transferType) || "pincode_auth_failed".equals(transferType);
        }
        return false;
    }

    public boolean hasMatchingUnit(Unit expectedUnit) {
        Preconditions.checkNotNull(expectedUnit);
        return expectedUnit.match(this.getUnit());
    }

    @Override
    public void handleUnknownField(String fieldName, String fieldValue) {
        switch (fieldName) {
            case "unitType": {
                this.counterType = LegacyLimitsConverter.extractCounterTypeFrom(fieldValue);
                this.matchRules = LegacyLimitsConverter.convertToCounterMatchRules(fieldValue);
                break;
            }
            case "modifierUnitType": {
                List<ModifierMatchRule> matchRules = LegacyLimitsConverter.convertToModifierMatchRules(fieldValue);
                if (matchRules.isEmpty()) break;
                this.getModifierConfigurations().forEach(mc -> mc.setMatchRules(matchRules));
                break;
            }
        }
    }

    void setMatchRulesIfNotUpgraded(List<CounterMatchRule> matchRules) {
        if (!matchRules.isEmpty()) {
            this.setMatchRules(matchRules);
        }
    }

    public boolean isRatingCounter() {
        return this.counterType == RatingCounterType.RATING_VALUE;
    }

    public static enum NoCounterType implements CounterType
    {
        NONE;


        @Override
        public String getName() {
            return this.name();
        }
    }

    public static enum DynamicType {
        NOT_DYNAMIC,
        DAY,
        WEEK;

    }

    public static enum CounterConfigurationType {
        INDIVIDUAL,
        SHARED;

    }
}

