/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierMatchRule;
import com.ericsson.em.emc.m3externallog.json.JsonMapper;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.persistence.DeepCloneable;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@Entity
public class ModifierConfiguration
extends BaseEntity
implements Serializable,
DeepCloneable<ModifierConfiguration> {
    private static final long serialVersionUID = 1L;
    @JsonMapper.NotMapped
    private CounterConfiguration counterConfiguration;
    private String className;
    private BigDecimal startValue;
    private BigDecimal endValue;
    private String name;
    private String data;
    private List<ModifierMatchRule> matchRules = new LinkedList<ModifierMatchRule>();

    public ModifierConfiguration() {
    }

    public ModifierConfiguration(long id) {
        this.mId = id;
    }

    ModifierConfiguration(ModifierConfiguration modifierConfiguration) {
        super((BaseEntity)modifierConfiguration);
        this.className = modifierConfiguration.className;
        this.startValue = modifierConfiguration.startValue;
        this.endValue = modifierConfiguration.endValue;
        this.data = modifierConfiguration.data;
        this.name = modifierConfiguration.name;
        modifierConfiguration.matchRules.stream().map(o -> new ModifierMatchRule((ModifierMatchRule)o, this)).forEach(this.matchRules::add);
    }

    @ManyToOne
    public CounterConfiguration getCounterConfiguration() {
        return this.counterConfiguration;
    }

    public void setCounterConfiguration(CounterConfiguration counterConfiguration) {
        this.counterConfiguration = counterConfiguration;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public BigDecimal getStartValue() {
        return this.startValue;
    }

    public void setStartValue(BigDecimal startValue) {
        this.startValue = startValue;
    }

    public BigDecimal getEndValue() {
        return this.endValue;
    }

    public void setEndValue(BigDecimal endValue) {
        this.endValue = endValue;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<ModifierMatchRule> getMatchRules() {
        return this.matchRules;
    }

    public void setMatchRules(List<ModifierMatchRule> matchRules) {
        this.matchRules = matchRules;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return ModifierConfiguration.class.getSimpleName() + "[id=" + this.mId + "]";
    }

    protected void validate() {
    }

    @Override
    public ModifierConfiguration deepClone() {
        return new ModifierConfiguration(this);
    }

    public ModifierConfiguration deepCloneWithoutId() {
        ModifierConfiguration modifierConfiguration = new ModifierConfiguration(this);
        modifierConfiguration.mId = null;
        return modifierConfiguration;
    }

    public boolean isSimilarTo(ModifierConfiguration other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        for (ModifierMatchRule mmr : this.matchRules) {
            if (other.matchRules.stream().filter(mmr::equalsToIgnoreId).findAny().isPresent()) continue;
            return false;
        }
        return Objects.equals(this.data, other.data);
    }

    public boolean equalsToIgnoreId(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifierConfiguration that = (ModifierConfiguration)o;
        return Objects.equals(this.className, that.className) && this.equalsToIgnoreIdAndClassName(o);
    }

    public boolean equalsToIgnoreIdAndClassName(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifierConfiguration that = (ModifierConfiguration)o;
        return Objects.equals(this.startValue, that.startValue) && Objects.equals(this.endValue, that.endValue) && Objects.equals(this.name, that.name) && Objects.equals(this.data, that.data) && (this.matchRules.isEmpty() && that.matchRules.isEmpty() || this.matchRules.stream().anyMatch(ruleA -> that.matchRules.stream().anyMatch(ruleB -> ruleB.equalsToIgnoreId(ruleA))));
    }
}

