/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfigurationFPDAOBean;
import com.ericsson.em.emc.hierarchies.persistence.ModifierMatchRuleDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.deployer.ApplicationContext;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"hier.modifierconfiguration.S"})
public class ModifierConfigurationDAOBean
extends CryptoExtendedBaseEntityDAOBean<ModifierConfiguration>
implements ModifierConfigurationDAO {
    static final String FINGERPRINT_KEY = "hier.modifierconfiguration.S";
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final String TABLE_NAME = "hier$modifierconfiguration";
    private static final String TABLE_SEQUENCE_NAME = "hier$modifierconfiguration_seq";
    @EJB
    private IndividualCounterConfigurationManager individualCounterConfigurationManager;
    @EJB
    private ModifierMatchRuleDAO modifierMatchRuleDAO;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public List<ModifierConfiguration> findModifierConfigurations(CounterConfiguration counterConfiguration) {
        List modifierConfigurations = this.findMultiple(this.getSelectStatement() + " where " + TableColumn.FK_COUNTERCONFIGURATION.name() + "= ? ", new Object[]{counterConfiguration.getId()});
        for (ModifierConfiguration modifierConfiguration : modifierConfigurations) {
            modifierConfiguration.setMatchRules(this.modifierMatchRuleDAO.getMatchRules(modifierConfiguration));
            modifierConfiguration.setCounterConfiguration(counterConfiguration);
        }
        return modifierConfigurations;
    }

    @Override
    public ModifierConfiguration create(ModifierConfiguration modifierConfiguration, CounterConfiguration counterConfiguration) {
        LinkedList<ModifierConfiguration> modifierConfigurations = new LinkedList<ModifierConfiguration>(counterConfiguration.getModifierConfigurations());
        modifierConfigurations.remove(modifierConfiguration);
        modifierConfiguration.setCounterConfiguration(counterConfiguration);
        modifierConfiguration = (ModifierConfiguration)super.create((BaseEntity)modifierConfiguration);
        modifierConfigurations.add(modifierConfiguration);
        counterConfiguration.setModifierConfigurations(modifierConfigurations);
        this.modifierMatchRuleDAO.setMatchRules(modifierConfiguration.getMatchRules(), modifierConfiguration);
        if (counterConfiguration.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL) {
            this.individualCounterConfigurationManager.update((IndividualCounterConfiguration)counterConfiguration);
        }
        return modifierConfiguration;
    }

    @Override
    public ModifierConfiguration update(ModifierConfiguration modifierConfiguration) {
        ModifierConfiguration updated = (ModifierConfiguration)super.update((BaseEntity)modifierConfiguration);
        CounterConfiguration counterConfiguration = modifierConfiguration.getCounterConfiguration();
        if (counterConfiguration.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL) {
            this.individualCounterConfigurationManager.update((IndividualCounterConfiguration)counterConfiguration);
        }
        this.modifierMatchRuleDAO.setMatchRules(updated.getMatchRules(), updated);
        return updated;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        ModifierConfiguration modifierConfiguration = (ModifierConfiguration)baseEntity;
        int i = 1;
        preparedStatement.setLong(i++, modifierConfiguration.getCounterConfiguration().getId());
        preparedStatement.setBigDecimal(i++, modifierConfiguration.getStartValue());
        preparedStatement.setBigDecimal(i++, modifierConfiguration.getEndValue());
        preparedStatement.setString(i++, modifierConfiguration.getClassName());
        preparedStatement.setString(i++, modifierConfiguration.getData());
        preparedStatement.setString(i++, modifierConfiguration.getName());
        return this.assignFingerprint(preparedStatement, i, new Object[]{modifierConfiguration.getCounterConfiguration().getId(), modifierConfiguration.getStartValue(), modifierConfiguration.getEndValue(), modifierConfiguration.getClassName(), modifierConfiguration.getData(), modifierConfiguration.getName()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        ModifierConfiguration modifierConfiguration = (ModifierConfiguration)baseEntity;
        modifierConfiguration.setClassName(resultSet.getString("classname"));
        modifierConfiguration.setStartValue(resultSet.getBigDecimal("startvalue"));
        modifierConfiguration.setEndValue(resultSet.getBigDecimal("endvalue"));
        modifierConfiguration.setData(resultSet.getString("data"));
        modifierConfiguration.setName(resultSet.getString("name"));
    }

    @Override
    public void delete(ModifierConfiguration aModifierConfiguration) {
        super.delete((BaseEntity)aModifierConfiguration);
        CounterConfiguration counterConfiguration = aModifierConfiguration.getCounterConfiguration();
        LinkedList<ModifierConfiguration> listToUseForRemove = new LinkedList<ModifierConfiguration>(counterConfiguration.getModifierConfigurations());
        listToUseForRemove.remove(aModifierConfiguration);
        counterConfiguration.setModifierConfigurations(listToUseForRemove);
        if (counterConfiguration.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL) {
            this.individualCounterConfigurationManager.update((IndividualCounterConfiguration)counterConfiguration);
        }
        this.modifierMatchRuleDAO.deleteCascade(aModifierConfiguration);
    }

    protected ModifierConfiguration createManagedEntity() {
        return new ModifierConfiguration();
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return ModifierConfiguration.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getLong(TableColumn.FK_COUNTERCONFIGURATION.name()), resultSet.getBigDecimal(TableColumn.STARTVALUE.name()), resultSet.getBigDecimal(TableColumn.ENDVALUE.name()), resultSet.getString(TableColumn.CLASSNAME.name()), resultSet.getString(TableColumn.DATA.name()), resultSet.getString(TableColumn.NAME.name())};
        }
        return null;
    }

    public Class<? extends CryptoExtendedBaseEntityDAOBean> getDaoBeanForUpdateFpCli() {
        return ModifierConfigurationFPDAOBean.class;
    }

    private static enum TableColumn {
        ID,
        FK_COUNTERCONFIGURATION,
        STARTVALUE,
        ENDVALUE,
        CLASSNAME,
        DATA,
        NAME,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

