/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.PeriodDAOBean;
import com.ericsson.em.emc.hierarchies.persistence.Periodizable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

abstract class PeriodizableManagerBean<EntityType extends BaseEntity>
extends PeriodDAOBean<EntityType> {
    PeriodizableManagerBean() {
    }

    @Override
    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        Periodizable periodizable = (Periodizable)baseEntity;
        int i = super.assign((BaseEntity)periodizable, preparedStatement);
        preparedStatement.setInt(i++, periodizable.getPeriodType().ordinal());
        preparedStatement.setString(i++, periodizable.isBalanceReuseable() ? "Y" : "N");
        preparedStatement.setInt(i++, periodizable.getPeriodLength());
        preparedStatement.setInt(i++, periodizable.getStartDayInMonth());
        return i;
    }

    @Override
    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        Periodizable periodizable = (Periodizable)baseEntity;
        int periodTypeOrdinal = resultSet.getInt("periodtype");
        for (Periodizable.PeriodType periodType : Periodizable.PeriodType.values()) {
            if (periodType.ordinal() != periodTypeOrdinal) continue;
            periodizable.setPeriodType(periodType);
            break;
        }
        periodizable.setBalanceReuseable(resultSet.getString("balancereuseable").equals("Y"));
        periodizable.setPeriodLength(resultSet.getInt("periodlength"));
        periodizable.setStartDayInMonth(resultSet.getInt("startdayinmonth"));
    }
}

