/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.CounterMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.CounterMatchRuleBuilder;
import com.ericsson.em.emc.hierarchies.persistence.GlobalParameter;
import com.ericsson.em.emc.hierarchies.persistence.GlobalParameterDAO;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.Periodizable;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDefaultSettingsHelper;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.google.common.collect.Lists;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

@Singleton
public class ProfileDefaultSettingsHelperBean
implements ProfileDefaultSettingsHelper {
    private static final String SERVICE_AUTHORIZATION = "Authorization";
    private static final String DEFAULT_PARAMETER_AUTHORIZATION_SERVICE_PREFIX = "account_holder_profile.authorization.";
    private static final String UNSUSPEND_SUFFIX = "_unsuspend";
    private static final String COUNTER_TYPE_PASSWORD = "password";
    private static final String COUNTER_TYPE_PINCODE = "pincode";
    private static final String COUNTER_OPERATION_TYPE_SUFFIX = "_auth_failed";
    private static final String COUNTER_OPERATION_TYPE_UNSUSPEND_SUFFIX = "_manual_unsuspend";
    private static final String NAME = ".name";
    private static final String MAX_ALLOWED_NUMBER = ".max_allowed_number";
    private static final String MAX_ALLOWED_SUSPENDED_ATTEMPTS = ".max_allowed_suspended_attempts";
    private static final String TIME_DELAY_ON_SUSPENDED_ATTEMPT = ".time_delay_on_suspended_attempt";
    private static final String MAX_MANUAL_TIME_DELAY_RESET = ".max_manual_time_delay_reset";
    public static final String LOGIN_COUNTER_CLASS_NAME = "com.ericsson.em.emc.accountholder.authentication.AuthenticationFailedModifier";
    private static final String LOGIN_COUNTER_MANUAL_UNSUSPEND_CLASS_NAME = "com.ericsson.em.emc.accountholder.authentication.ManualUnsuspendModifier";
    public static final String LOGIN_COUNTER_CLASS_NAME_SOFT_LIMIT = "com.ericsson.em.emc.accountholder.authentication.AuthenticationFailedSoftLimitModifier";
    private static final String AUTHENTICATION_MULTIPLE_FAILED_LOGIN_ATTEMPTS = "AUTHENTICATION_MULTIPLE_FAILED_LOGIN_ATTEMPTS";
    @EJB
    private GlobalParameterDAO globalParameterDAO;
    @EJB
    private IndividualCounterConfigurationManager individualCounterConfigurationManager;
    @EJB
    private ProfileServiceDAO serviceDAO;
    @EJB
    private ModifierConfigurationDAO modifierConfigurationDAO;

    @Override
    public Profile createOrUpdateAuthorizationService(Profile profile) {
        Profile updatedProfile = null;
        if (this.isAccountHolderProfile(profile) && this.hasDefaultSettings()) {
            Optional<ProfileService> authService = profile.getServices().stream().filter(service -> SERVICE_AUTHORIZATION.equals(service.getName())).findFirst();
            if (!authService.isPresent()) {
                ProfileService service2 = new ProfileService();
                service2.setName(SERVICE_AUTHORIZATION);
                service2.setBalanceReuseable(true);
                service2 = this.serviceDAO.create(service2, profile);
                updatedProfile = this.addCounters(service2).getProfile();
            } else if (authService.get().getIndividualCounterConfigurations().isEmpty()) {
                updatedProfile = this.addCounters(authService.get()).getProfile();
            }
        }
        return updatedProfile != null ? updatedProfile : profile;
    }

    private boolean isAccountHolderProfile(Profile profile) {
        Optional<ProfileService> general = profile.getServices().stream().filter(service -> service.getName().equals("General")).findFirst();
        if (general.isPresent()) {
            return "Account Holder".equals(general.get().getPropertyValue("Profile Type"));
        }
        return false;
    }

    private ProfileService addCounters(ProfileService service) {
        IndividualCounterConfiguration createCounterConfiguration = this.createAuthenticationCounterConfiguration(service, COUNTER_TYPE_PASSWORD, false);
        createCounterConfiguration = this.createAuthenticationCounterConfiguration(createCounterConfiguration.getService(), COUNTER_TYPE_PASSWORD, true);
        createCounterConfiguration = this.createAuthenticationCounterConfiguration(createCounterConfiguration.getService(), COUNTER_TYPE_PINCODE, false);
        createCounterConfiguration = this.createAuthenticationCounterConfiguration(createCounterConfiguration.getService(), COUNTER_TYPE_PINCODE, true);
        return createCounterConfiguration.getService();
    }

    private IndividualCounterConfiguration createAuthenticationCounterConfiguration(ProfileService profileService, String counterType, boolean isUnsuspended) {
        CounterConfiguration counterConfiguration = new IndividualCounterConfiguration();
        String counterName = this.getGParam(counterType, NAME).getValue();
        counterConfiguration.setName((String)(isUnsuspended ? counterName + UNSUSPEND_SUFFIX : counterName));
        counterConfiguration.setBalanceReuseable(true);
        counterConfiguration.setCounterType(AuthenticationCounterType.AUTHENTICATION);
        counterConfiguration.setPeriodType(Periodizable.PeriodType.NO_PERIOD);
        counterConfiguration.setDynamicType(CounterConfiguration.DynamicType.NOT_DYNAMIC);
        counterConfiguration.setDynamicLength(0);
        counterConfiguration.setDefaultValue(BigDecimal.ZERO);
        counterConfiguration.setMatchRules(ProfileDefaultSettingsHelperBean.convertToCounterMatchRules(counterType + (isUnsuspended ? COUNTER_OPERATION_TYPE_UNSUSPEND_SUFFIX : COUNTER_OPERATION_TYPE_SUFFIX)));
        counterConfiguration = this.individualCounterConfigurationManager.create((IndividualCounterConfiguration)counterConfiguration, profileService);
        if (isUnsuspended) {
            ModifierConfiguration createdModifierConfiguration = this.createModifierConfiguration(counterConfiguration, counterType, this.getValue(counterType, MAX_MANUAL_TIME_DELAY_RESET), LOGIN_COUNTER_MANUAL_UNSUSPEND_CLASS_NAME, true);
            counterConfiguration = createdModifierConfiguration.getCounterConfiguration();
        } else {
            BigDecimal startValue = this.getValue(counterType, MAX_ALLOWED_NUMBER);
            ModifierConfiguration createdModifierConfiguration = this.createModifierConfiguration(counterConfiguration, counterType, startValue, LOGIN_COUNTER_CLASS_NAME_SOFT_LIMIT, false);
            counterConfiguration = createdModifierConfiguration.getCounterConfiguration();
            BigDecimal shouldBeAddedToPreviousStartValue = this.getValue(counterType, MAX_ALLOWED_SUSPENDED_ATTEMPTS);
            createdModifierConfiguration = this.createModifierConfiguration(counterConfiguration, counterType, startValue.add(shouldBeAddedToPreviousStartValue), LOGIN_COUNTER_CLASS_NAME, false);
            counterConfiguration = createdModifierConfiguration.getCounterConfiguration();
        }
        return counterConfiguration;
    }

    private static List<CounterMatchRule> convertToCounterMatchRules(String transferType) {
        LinkedList<CounterMatchRule> matchRules = Lists.newLinkedList();
        matchRules.add((CounterMatchRule)new CounterMatchRuleBuilder().transferType(transferType).get());
        return matchRules;
    }

    private BigDecimal getValue(String counterType, String suffix) {
        return BigDecimal.valueOf(Long.parseLong(this.getGParam(counterType, suffix).getValue()));
    }

    private ModifierConfiguration createModifierConfiguration(CounterConfiguration counterConfiguration, String counterType, BigDecimal startValue, String className, boolean isUnsuspended) {
        ModifierConfiguration modifierConfiguration = new ModifierConfiguration();
        modifierConfiguration.setStartValue(startValue);
        modifierConfiguration.setEndValue(BigDecimal.valueOf(999999L));
        modifierConfiguration.setClassName(className);
        if (!isUnsuspended) {
            modifierConfiguration.setData(LOGIN_COUNTER_CLASS_NAME_SOFT_LIMIT.equals(className) ? this.getGParam(counterType, TIME_DELAY_ON_SUSPENDED_ATTEMPT).getValue() : AUTHENTICATION_MULTIPLE_FAILED_LOGIN_ATTEMPTS);
        }
        return this.modifierConfigurationDAO.create(modifierConfiguration, counterConfiguration);
    }

    private String getAuthParamName(String counterType, String suffix) {
        return DEFAULT_PARAMETER_AUTHORIZATION_SERVICE_PREFIX + counterType + suffix;
    }

    private GlobalParameter getGParam(String type, String suffix) {
        return this.globalParameterDAO.findByKey(this.getAuthParamName(type, suffix));
    }

    private boolean hasDefaultSettings() {
        return this.getGParam(COUNTER_TYPE_PASSWORD, NAME) != null && this.getGParam(COUNTER_TYPE_PASSWORD, MAX_ALLOWED_NUMBER) != null && this.getGParam(COUNTER_TYPE_PASSWORD, MAX_ALLOWED_SUSPENDED_ATTEMPTS) != null && this.getGParam(COUNTER_TYPE_PASSWORD, TIME_DELAY_ON_SUSPENDED_ATTEMPT) != null && this.getGParam(COUNTER_TYPE_PASSWORD, MAX_MANUAL_TIME_DELAY_RESET) != null && this.getGParam(COUNTER_TYPE_PINCODE, NAME) != null && this.getGParam(COUNTER_TYPE_PINCODE, MAX_ALLOWED_NUMBER) != null && this.getGParam(COUNTER_TYPE_PINCODE, MAX_ALLOWED_SUSPENDED_ATTEMPTS) != null && this.getGParam(COUNTER_TYPE_PINCODE, TIME_DELAY_ON_SUSPENDED_ATTEMPT) != null && this.getGParam(COUNTER_TYPE_PINCODE, MAX_MANUAL_TIME_DELAY_RESET) != null;
    }

    public static enum AuthenticationCounterType implements CounterType
    {
        AUTHENTICATION;


        @Override
        public String getName() {
            return this.name();
        }
    }
}

