/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsProfileName;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Entity
@Validatable
public class ProfileEventEntity
extends BaseEntity {
    @NotNull
    private final LocalDateTime timestamp;
    @NotNull
    private final ProfileEvent profileEvent;
    @NotNull
    @IsProfileName
    private final String profileName;
    @NotNull
    @IsIdentity
    private final String userIdentity;
    @NotNull
    private final Long profileIdentity;

    ProfileEventEntity(Builder builder) {
        this.mId = builder.id;
        this.timestamp = builder.timestamp;
        this.profileEvent = builder.profileEvent;
        this.profileName = builder.profileName;
        this.profileIdentity = builder.profileIdentity;
        this.userIdentity = builder.userIdentity;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public Long getProfileIdentity() {
        return this.profileIdentity;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public ProfileEvent getProfileEvent() {
        return this.profileEvent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Long id;
        private LocalDateTime timestamp;
        private ProfileEvent profileEvent;
        private String profileName;
        private String userIdentity;
        private Long profileIdentity;

        public Builder id(Long value) {
            this.id = value;
            return this;
        }

        public Builder profileName(String value) {
            this.profileName = value;
            return this;
        }

        public Builder profileIdentity(Long value) {
            this.profileIdentity = value;
            return this;
        }

        public Builder timestamp(LocalDateTime value) {
            this.timestamp = value;
            return this;
        }

        public Builder userIdentity(String value) {
            this.userIdentity = value;
            return this;
        }

        public Builder profileEvent(ProfileEvent value) {
            this.profileEvent = value;
            return this;
        }

        public ProfileEventEntity build() {
            return Validation.validate(new ProfileEventEntity(this));
        }
    }

    public static enum ProfileEvent {
        CREATED,
        CLONED,
        EDITED,
        IMPORTED,
        DELETED;

    }
}

