/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.Periodizable;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.Property;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterOverride;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import com.ericsson.em.emc.m3externallog.json.JsonMapper;
import com.ericsson.lwac.persistence.DeepCloneable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Entity
public class ProfileService
extends Periodizable
implements Serializable,
DeepCloneable<ProfileService> {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonMapper.NotMapped
    private ProfileService parent;
    private List<ProfileService> children = new LinkedList<ProfileService>();
    @JsonMapper.NotMapped
    private Profile profile;
    private List<IndividualCounterConfiguration> counterConfigurations = new LinkedList<IndividualCounterConfiguration>();
    private List<Property> properties = new LinkedList<Property>();
    private List<ThresholdConfiguration> thresholdConfigurations = new LinkedList<ThresholdConfiguration>();
    @JsonMapper.NotMapped
    private final Map<String, SharedCounterConfiguration> sharedCounterConfigurationMap = new HashMap<String, SharedCounterConfiguration>();
    private final List<String> sharedCounterRelations = new LinkedList<String>();
    private final List<SharedCounterOverride> sharedCounterOverrides = new LinkedList<SharedCounterOverride>();
    @JsonMapper.NotMapped
    private final Map<String, SharedCounterOverride> sharedCounterOverrideMap = new HashMap<String, SharedCounterOverride>();

    public ProfileService() {
    }

    protected ProfileService(ProfileService profileService) {
        super(profileService);
        DeepCloneable<ProfileService> clone;
        this.name = profileService.getName();
        this.children = new LinkedList<ProfileService>();
        for (ProfileService profileService2 : profileService.getChildren()) {
            clone = profileService2.deepClone();
            ((ProfileService)clone).setParent(this);
            this.children.add((ProfileService)clone);
        }
        for (IndividualCounterConfiguration individualCounterConfiguration : profileService.getIndividualCounterConfigurations()) {
            clone = individualCounterConfiguration.deepClone();
            ((IndividualCounterConfiguration)clone).setService(this);
            this.counterConfigurations.add((IndividualCounterConfiguration)clone);
        }
        for (SharedCounterConfiguration sharedCounterConfiguration : profileService.getSharedCounterConfigurations()) {
            clone = sharedCounterConfiguration.deepClone();
            this.sharedCounterConfigurationMap.put(((CounterConfiguration)((Object)clone)).getName(), (SharedCounterConfiguration)clone);
            this.sharedCounterRelations.add(((CounterConfiguration)((Object)clone)).getName());
        }
        for (SharedCounterOverride sharedCounterOverride : profileService.getSharedCounterOverrides().stream().filter(it -> it.getLimit() != null).collect(Collectors.toList())) {
            clone = sharedCounterOverride.deepClone();
            this.sharedCounterOverrides.add((SharedCounterOverride)clone);
            this.sharedCounterOverrideMap.put(((SharedCounterOverride)clone).getName(), (SharedCounterOverride)clone);
        }
        for (ThresholdConfiguration thresholdConfiguration : profileService.getThresholdConfigurations()) {
            clone = thresholdConfiguration.deepClone();
            ((ThresholdConfiguration)clone).setService(this);
            this.thresholdConfigurations.add((ThresholdConfiguration)clone);
        }
        for (Property property : profileService.getProperties()) {
            clone = property.deepClone();
            ((Property)clone).setService(this);
            this.properties.add((Property)clone);
        }
    }

    public ProfileService(String name) {
        this.name = name;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="fk_service")
    public List<Property> getProperties() {
        return this.properties;
    }

    public List<ThresholdConfiguration> getThresholdConfigurations() {
        return this.thresholdConfigurations;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="parent")
    public List<ProfileService> getChildren() {
        return this.children;
    }

    public void setChildren(List<ProfileService> children) {
        this.children = children;
    }

    public List<IndividualCounterConfiguration> getIndividualCounterConfigurations() {
        return this.counterConfigurations;
    }

    public List<SharedCounterConfiguration> getSharedCounterConfigurations() {
        return new ArrayList<SharedCounterConfiguration>(this.sharedCounterConfigurationMap.values());
    }

    public List<SharedCounterOverride> getSharedCounterOverrides() {
        return this.sharedCounterOverrides;
    }

    public Optional<SharedCounterOverride> getSharedCounterOverride(String counterName) {
        return Optional.ofNullable(this.sharedCounterOverrideMap.getOrDefault(counterName, null));
    }

    public void setIndividualCounterConfigurations(List<IndividualCounterConfiguration> counterConfigurations) {
        this.counterConfigurations = counterConfigurations;
    }

    public void setSharedCounterConfigurations(List<SharedCounterConfiguration> sharedCounterConfigurations) {
        for (SharedCounterConfiguration sharedCounterConfiguration : sharedCounterConfigurations) {
            this.sharedCounterConfigurationMap.put(sharedCounterConfiguration.getName(), sharedCounterConfiguration);
            this.sharedCounterRelations.add(sharedCounterConfiguration.getName());
        }
    }

    public void setSharedCounterOverrides(List<SharedCounterOverride> sharedCounterOverrides) {
        for (SharedCounterOverride sharedCounterOverride : sharedCounterOverrides) {
            if (sharedCounterOverride.getLimit() == null) continue;
            this.sharedCounterOverrideMap.put(sharedCounterOverride.getName(), sharedCounterOverride);
            this.sharedCounterOverrides.add(sharedCounterOverride);
        }
    }

    public void overwriteSharedCounterConfigurations(List<SharedCounterConfiguration> sharedCounterConfigurations) {
        this.sharedCounterRelations.clear();
        this.sharedCounterConfigurationMap.clear();
        this.setSharedCounterConfigurations(sharedCounterConfigurations);
    }

    public void overwriteSharedCounterOverrides(List<SharedCounterOverride> sharedCounterOverrides) {
        this.sharedCounterOverrides.clear();
        this.sharedCounterOverrideMap.clear();
        this.setSharedCounterOverrides(sharedCounterOverrides);
    }

    public void addSharedCounterConfiguration(SharedCounterConfiguration sharedCounterConfiguration) {
        this.sharedCounterConfigurationMap.put(sharedCounterConfiguration.getName(), sharedCounterConfiguration);
        this.sharedCounterRelations.add(sharedCounterConfiguration.getName());
    }

    public void addSharedCounterOverride(SharedCounterOverride sharedCounterOverride) {
        if (sharedCounterOverride.getLimit() == null) {
            return;
        }
        this.sharedCounterOverrideMap.put(sharedCounterOverride.getName(), sharedCounterOverride);
        this.sharedCounterOverrides.add(sharedCounterOverride);
    }

    public void removeSharedCounterConfiguration(String sharedCounterConfigurationName) {
        SharedCounterConfiguration existing = this.sharedCounterConfigurationMap.get(sharedCounterConfigurationName);
        if (existing != null) {
            this.sharedCounterConfigurationMap.remove(sharedCounterConfigurationName);
            this.sharedCounterRelations.remove(sharedCounterConfigurationName);
        }
    }

    public void removeSharedCounterOverride(String sharedCounterConfigurationName) {
        this.sharedCounterOverrideMap.remove(sharedCounterConfigurationName);
        this.sharedCounterOverrides.stream().filter(it -> it.getName().equals(sharedCounterConfigurationName)).findFirst().ifPresent(this.sharedCounterOverrides::remove);
    }

    public List<String> getSharedCounterRelations() {
        return this.sharedCounterRelations;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public String getPropertyValue(String name) {
        Property property = this.getProperty(name);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public Property getProperty(String name) {
        return this.properties.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }

    public void setThresholdConfigurations(List<ThresholdConfiguration> thresholdConfigurations) {
        this.thresholdConfigurations = thresholdConfigurations;
    }

    @ManyToOne
    public ProfileService getParent() {
        return this.parent;
    }

    public void setParent(ProfileService parent) {
        this.parent = parent;
    }

    @Column(nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "com.ericsson.mpah.hierarchies.persistence.ProfileService[id=" + this.mId + "]";
    }

    public Profile getProfile() {
        if (this.parent == null) {
            return this.profile;
        }
        return this.parent.getProfile();
    }

    public void setProfile(Profile profile) {
        if (this.parent == null) {
            this.profile = profile;
        }
    }

    @Override
    public ProfileService deepClone() {
        return new ProfileService(this);
    }

    public ProfileService getChildByName(String name) {
        for (ProfileService child : this.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public ProfileService getChildByName(String name, boolean ignoreCase) {
        if (!ignoreCase) {
            return this.getChildByName(name);
        }
        for (ProfileService child : this.getChildren()) {
            if (!child.getName().equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }
}

