/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.PeriodizableManagerBean;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceFPDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceToUpdateFP;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.joda.time.DateTime;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"hier.service.S"})
public class ProfileServiceFPDAOBean
extends PeriodizableManagerBean<ProfileServiceToUpdateFP>
implements ProfileServiceFPDAO {
    static final String FINGERPRINT_KEY = "hier.service.S";
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final String TABLE_NAME = "hier$service";
    private static final String TABLE_SEQUENCE_NAME = "hier$service_seq";

    @Override
    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        ProfileServiceToUpdateFP profileService = (ProfileServiceToUpdateFP)baseEntity;
        int i = super.assign((BaseEntity)profileService, preparedStatement);
        preparedStatement.setString(i++, profileService.getName());
        preparedStatement.setLong(i++, profileService.getFk_profile());
        if (profileService.getFk_parentservice() == 0L) {
            preparedStatement.setNull(i++, -5);
        } else {
            preparedStatement.setLong(i++, profileService.getFk_parentservice());
        }
        return this.assignFingerprint(preparedStatement, i, new Object[]{null != profileService.getStartDateTime() ? ProfileServiceFPDAOBean.getTimestamp((DateTime)profileService.getStartDateTime()) : null, null != profileService.getEndDateTime() ? ProfileServiceFPDAOBean.getTimestamp((DateTime)profileService.getEndDateTime()) : null, profileService.getPeriodType().ordinal(), profileService.isBalanceReuseable() ? "Y" : "N", profileService.getPeriodLength(), profileService.getStartDayInMonth(), profileService.getName(), profileService.getFk_profile(), profileService.getFk_parentservice() == 0L ? null : Long.valueOf(profileService.getFk_parentservice())});
    }

    @Override
    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        ProfileServiceToUpdateFP profileService = (ProfileServiceToUpdateFP)baseEntity;
        profileService.setName(resultSet.getString(TableColumn.NAME.name()));
        profileService.setFk_profile(resultSet.getLong(TableColumn.FK_PROFILE.name()));
        profileService.setFk_parentservice(resultSet.getLong(TableColumn.FK_PARENTSERVICE.name()));
    }

    public ProfileServiceToUpdateFP update(ProfileServiceToUpdateFP entry) {
        return (ProfileServiceToUpdateFP)super.update((BaseEntity)entry);
    }

    public ProfileServiceToUpdateFP updateDefaultFingerprint(ProfileServiceToUpdateFP entry) {
        return (ProfileServiceToUpdateFP)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FINGERPRINTVERSION) + "= ? order by " + String.valueOf((Object)TableColumn.ID) + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    protected ProfileServiceToUpdateFP createManagedEntity() {
        return new ProfileServiceToUpdateFP();
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return ProfileService.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getInt(TableColumn.PERIODTYPE.name()), resultSet.getString(TableColumn.BALANCEREUSEABLE.name()), resultSet.getInt(TableColumn.PERIODLENGTH.name()), resultSet.getInt(TableColumn.STARTDAYINMONTH.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getLong(TableColumn.FK_PROFILE.name()), ProfileServiceFPDAOBean.getNullableLongFromResultSet((ResultSet)resultSet, (String)TableColumn.FK_PARENTSERVICE.name())};
        }
        return null;
    }

    private static enum TableColumn {
        ID,
        STARTDATETIME,
        ENDDATETIME,
        PERIODTYPE,
        BALANCEREUSEABLE,
        PERIODLENGTH,
        STARTDAYINMONTH,
        NAME,
        FK_PROFILE,
        FK_PARENTSERVICE,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

