/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.counters.CounterTypeRegistry;
import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.CounterIdentifierMatchParameters;
import com.ericsson.em.emc.hierarchies.persistence.CounterMatchRuleDAO;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.PeriodizableManagerBean;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfigurationDAO;
import com.ericsson.lwac.cache.Cache;
import com.ericsson.lwac.cache.CacheService;
import com.ericsson.lwac.cache.LockingType;
import com.ericsson.lwac.cache.SecondaryCache;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"hier.sharedcounterconfig.S"})
public class SharedCounterConfigurationDAOBean
extends PeriodizableManagerBean<SharedCounterConfiguration>
implements SharedCounterConfigurationDAO {
    static final String FINGERPRINT_KEY = "hier.sharedcounterconfig.S";
    public static final int DEFAULT_FINGERPRINT_VERSION = 1;
    private static final int CURRENT_FINGERPRINT_VERSION = 3;
    private static final String TABLE_NAME = "hier$sharedcounterconfig";
    private static final String TABLE_SEQUENCE_NAME = "hier$counterconfiguration_seq";
    @EJB
    private ModifierConfigurationDAO modifierConfigurationManager;
    @EJB
    private CounterMatchRuleDAO counterMatchRuleDAO;
    @Resource
    private ApplicationContext applicationContext;
    @EJB
    private CounterTypeRegistry counterTypeRegistry;
    private Cache<Long, SharedCounterConfiguration> cache;
    @Resource
    private CacheService cacheService;

    @PostConstruct
    public void postConstruct() {
        if (this.cacheService != null) {
            this.cache = this.cacheService.createCache(Long.class, SharedCounterConfiguration.class, true);
            this.cache.addSecondaryCache(SharedCounterConfigSecondaryCache.NAME);
        }
    }

    @Override
    public int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        SharedCounterConfiguration sharedCounterConfiguration = (SharedCounterConfiguration)baseEntity;
        int i = 1;
        DateTime startDateTime = sharedCounterConfiguration.getStartDateTime();
        DateTime endDateTime = sharedCounterConfiguration.getEndDateTime();
        preparedStatement.setString(i++, sharedCounterConfiguration.getCounterType().getName());
        if (startDateTime != null) {
            preparedStatement.setObject(i++, (Object)SharedCounterConfigurationDAOBean.getTimestamp((DateTime)startDateTime), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        if (endDateTime != null) {
            preparedStatement.setObject(i++, (Object)SharedCounterConfigurationDAOBean.getTimestamp((DateTime)endDateTime), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        preparedStatement.setInt(i++, sharedCounterConfiguration.getPeriodType().ordinal());
        preparedStatement.setString(i++, sharedCounterConfiguration.isBalanceReuseable() ? "Y" : "N");
        preparedStatement.setInt(i++, sharedCounterConfiguration.getPeriodLength());
        preparedStatement.setInt(i++, sharedCounterConfiguration.getStartDayInMonth());
        preparedStatement.setString(i++, sharedCounterConfiguration.getName());
        preparedStatement.setString(i++, sharedCounterConfiguration.getExternalId());
        preparedStatement.setString(i++, sharedCounterConfiguration.hasUnit() ? sharedCounterConfiguration.getUnit().getValue() : null);
        preparedStatement.setInt(i++, sharedCounterConfiguration.getDynamicType().ordinal());
        preparedStatement.setInt(i++, sharedCounterConfiguration.getDynamicLength());
        preparedStatement.setString(i++, sharedCounterConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N");
        preparedStatement.setString(i++, sharedCounterConfiguration.getHardLimitNotificationOperationTypeName());
        preparedStatement.setString(i++, sharedCounterConfiguration.getDescription());
        preparedStatement.setBigDecimal(i++, sharedCounterConfiguration.getDefaultValue());
        preparedStatement.setBoolean(i++, sharedCounterConfiguration.isPersonalizedLimitAllowed());
        return this.assignFingerprint(preparedStatement, i, new Object[]{sharedCounterConfiguration.getCounterType().getName(), SharedCounterConfigurationDAOBean.getTimestamp((DateTime)startDateTime), SharedCounterConfigurationDAOBean.getTimestamp((DateTime)endDateTime), sharedCounterConfiguration.getPeriodType().ordinal(), sharedCounterConfiguration.isBalanceReuseable() ? "Y" : "N", sharedCounterConfiguration.getPeriodLength(), sharedCounterConfiguration.getStartDayInMonth(), sharedCounterConfiguration.getName(), sharedCounterConfiguration.getExternalId(), sharedCounterConfiguration.getUnit().getValue(), sharedCounterConfiguration.getDynamicType().ordinal(), sharedCounterConfiguration.getDynamicLength(), sharedCounterConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N", sharedCounterConfiguration.getHardLimitNotificationOperationTypeName(), sharedCounterConfiguration.getDescription(), sharedCounterConfiguration.getDefaultValue(), sharedCounterConfiguration.isPersonalizedLimitAllowed()});
    }

    @Override
    public void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        CounterConfiguration counterConfiguration = (CounterConfiguration)baseEntity;
        String counterTypeStr = MoreObjects.firstNonNull(resultSet.getString("counterType"), CounterConfiguration.NoCounterType.NONE.getName());
        CounterType counterType = this.counterTypeRegistry.getCounterType(counterTypeStr).orElseThrow(() -> new IllegalArgumentException("Unable to find counter type " + counterTypeStr));
        counterConfiguration.setCounterType(counterType);
        counterConfiguration.setName(resultSet.getString("name"));
        counterConfiguration.setExternalId(resultSet.getString("externalid"));
        int dynamicTypeOrdinal = resultSet.getInt("dynamictype");
        for (CounterConfiguration.DynamicType dynamicType : CounterConfiguration.DynamicType.values()) {
            if (dynamicType.ordinal() != dynamicTypeOrdinal) continue;
            counterConfiguration.setDynamicType(dynamicType);
            break;
        }
        counterConfiguration.setDynamicLength(resultSet.getInt("dynamiclength"));
        counterConfiguration.setModifierConfigurations(this.modifierConfigurationManager.findModifierConfigurations(counterConfiguration));
        counterConfiguration.setHardLimitNotificationsEnabled(resultSet.getString("hardlimitnotificationsenabled").equals("Y"));
        counterConfiguration.setHardLimitNotificationOperationTypeName(resultSet.getString("hardlimitnotificationname"));
        counterConfiguration.setDescription(resultSet.getString("description"));
        counterConfiguration.setUnit(Unit.fromString(resultSet.getString("unit")));
        counterConfiguration.setDefaultValue(resultSet.getBigDecimal("defaultvalue"));
        counterConfiguration.setPersonalizedLimitAllowed(resultSet.getBoolean("allowpersonallimit"));
    }

    @Override
    public SharedCounterConfiguration create(SharedCounterConfiguration sharedCounterConfiguration) {
        super.create((BaseEntity)sharedCounterConfiguration);
        sharedCounterConfiguration.setMatchRules(this.counterMatchRuleDAO.setMatchRules(sharedCounterConfiguration.getMatchRules(), sharedCounterConfiguration));
        this.updateCache(sharedCounterConfiguration);
        return sharedCounterConfiguration;
    }

    protected void updateCache(SharedCounterConfiguration sharedCounterConfiguration) {
        this.cache.update(sharedCounterConfiguration.getId(), sharedCounterConfiguration, new SecondaryCache[]{SharedCounterConfigSecondaryCache.NAME}, new String[]{sharedCounterConfiguration.getName()}, LockingType.optimistic);
    }

    protected void loadCache(SharedCounterConfiguration sharedCounterConfiguration) {
        this.cache.load(sharedCounterConfiguration.getId(), sharedCounterConfiguration, new SecondaryCache[]{SharedCounterConfigSecondaryCache.NAME}, new String[]{sharedCounterConfiguration.getName()});
    }

    @Override
    public SharedCounterConfiguration createWithId(SharedCounterConfiguration sharedCounterConfiguration) {
        super.createWithIdSet((BaseEntity)sharedCounterConfiguration);
        sharedCounterConfiguration.setMatchRules(this.counterMatchRuleDAO.setMatchRules(sharedCounterConfiguration.getMatchRules(), sharedCounterConfiguration));
        this.updateCache(sharedCounterConfiguration);
        return sharedCounterConfiguration;
    }

    public SharedCounterConfiguration createManagedEntity() {
        return new SharedCounterConfiguration();
    }

    @Override
    public SharedCounterConfiguration update(SharedCounterConfiguration sharedCounterConfiguration) {
        SharedCounterConfiguration updated = (SharedCounterConfiguration)super.update((BaseEntity)sharedCounterConfiguration);
        this.updateCache(sharedCounterConfiguration);
        this.counterMatchRuleDAO.setMatchRules(sharedCounterConfiguration.getMatchRules(), updated);
        return updated;
    }

    public SharedCounterConfiguration updateDefaultFingerprint(SharedCounterConfiguration entry) {
        return (SharedCounterConfiguration)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FINGERPRINTVERSION) + "= ? order by " + String.valueOf((Object)TableColumn.ID) + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    @Override
    public SharedCounterConfiguration find(long id) {
        SharedCounterConfiguration sharedCounterConfiguration = this.cache.getByPrimaryId(id);
        if (sharedCounterConfiguration == null && (sharedCounterConfiguration = (SharedCounterConfiguration)this.find(this.getSelectStatement() + " where id = ?", new Object[]{id})) != null) {
            sharedCounterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules(sharedCounterConfiguration));
            this.loadCache(sharedCounterConfiguration);
        }
        return sharedCounterConfiguration;
    }

    @Override
    public SharedCounterConfiguration findByName(String name) {
        SharedCounterConfiguration sharedCounterConfiguration = this.cache.getBySecondaryId(SharedCounterConfigSecondaryCache.NAME, name);
        if (sharedCounterConfiguration == null && (sharedCounterConfiguration = (SharedCounterConfiguration)this.find(this.getSelectStatement() + " where name = ?", new Object[]{name})) != null) {
            sharedCounterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules(sharedCounterConfiguration));
            this.loadCache(sharedCounterConfiguration);
        }
        return sharedCounterConfiguration;
    }

    @Override
    public List<SharedCounterConfiguration> getAll() {
        List counterConfigurations = this.findMultiple(this.getSelectStatement(), new Object[0]);
        counterConfigurations.stream().forEach(counterConfiguration -> counterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules((CounterConfiguration)counterConfiguration)));
        return Collections.unmodifiableList(counterConfigurations);
    }

    @Override
    public void delete(SharedCounterConfiguration sharedCounterConfiguration) {
        List<ModifierConfiguration> theModifiers = sharedCounterConfiguration.getModifierConfigurations();
        for (ModifierConfiguration theModifier : theModifiers) {
            if (theModifier.getId() == null) continue;
            this.modifierConfigurationManager.delete(theModifier);
        }
        super.delete((BaseEntity)sharedCounterConfiguration);
        this.cache.remove(sharedCounterConfiguration.getId());
        this.counterMatchRuleDAO.deleteCascade(sharedCounterConfiguration);
    }

    @Override
    public List<CounterConfiguration> findByMatchingAttributes(CounterIdentifierMatchParameters params) {
        List counterConfigurations = this.findMultiple(this.getSelectStatement() + " where counterType = ? and unit = ? and periodType = ? and periodLength = ?", new Object[]{params.getCounterType().getName(), params.getUnit().getValue(), params.getPeriodType().ordinal(), params.getPeriodLength()});
        counterConfigurations.stream().forEach(counterConfiguration -> counterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules((CounterConfiguration)counterConfiguration)));
        return Collections.unmodifiableList(counterConfigurations);
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return SharedCounterConfiguration.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 3;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getString(TableColumn.COUNTERTYPE.name()), resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.PERIODTYPE.name()), resultSet.getString(TableColumn.BALANCEREUSEABLE.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.PERIODLENGTH.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.STARTDAYINMONTH.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.EXTERNALID.name()), resultSet.getString(TableColumn.UNIT.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.DYNAMICTYPE.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.DYNAMICLENGTH.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name()), resultSet.getBigDecimal(TableColumn.DEFAULTVALUE.name())};
        }
        if (fingerprintVersion == 3) {
            return new Object[]{resultSet.getString(TableColumn.COUNTERTYPE.name()), resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.PERIODTYPE.name()), resultSet.getString(TableColumn.BALANCEREUSEABLE.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.PERIODLENGTH.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.STARTDAYINMONTH.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.EXTERNALID.name()), resultSet.getString(TableColumn.UNIT.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.DYNAMICTYPE.name()), SharedCounterConfigurationDAOBean.getNullableIntegerFromResultSet((ResultSet)resultSet, (String)TableColumn.DYNAMICLENGTH.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name()), resultSet.getBigDecimal(TableColumn.DEFAULTVALUE.name()), resultSet.getBoolean(TableColumn.ALLOWPERSONALLIMIT.name())};
        }
        return null;
    }

    @Override
    @VisibleForTesting
    public SharedCounterConfiguration getCacheData(long id, String name) {
        if (name != null && !name.isEmpty()) {
            return this.cache.getBySecondaryId(SharedCounterConfigSecondaryCache.NAME, name);
        }
        if (Objects.nonNull(id)) {
            return this.cache.getByPrimaryId(id);
        }
        return null;
    }

    static enum SharedCounterConfigSecondaryCache implements SecondaryCache
    {
        NAME("name");

        private final String name;

        private SharedCounterConfigSecondaryCache(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static enum TableColumn {
        ID,
        COUNTERTYPE,
        STARTDATETIME,
        ENDDATETIME,
        PERIODTYPE,
        BALANCEREUSEABLE,
        PERIODLENGTH,
        STARTDAYINMONTH,
        NAME,
        EXTERNALID,
        UNIT,
        DYNAMICTYPE,
        DYNAMICLENGTH,
        HARDLIMITNOTIFICATIONSENABLED,
        HARDLIMITNOTIFICATIONNAME,
        DESCRIPTION,
        DEFAULTVALUE,
        ALLOWPERSONALLIMIT,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

