/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.limits.LegacyLimitsConverter;
import com.ericsson.em.emc.hierarchies.persistence.Period;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.serialization.UnknownFieldAware;
import com.ericsson.em.emc.m3externallog.json.JsonMapper;
import com.ericsson.lwac.persistence.DeepCloneable;
import com.google.common.base.Preconditions;
import jakarta.persistence.Entity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@Entity
public class ThresholdConfiguration
extends Period
implements Serializable,
DeepCloneable<ThresholdConfiguration>,
UnknownFieldAware {
    private static final long serialVersionUID = 1L;
    @JsonMapper.NotMapped
    private ProfileService profileService;
    private String name;
    private String description;
    private BigDecimal threshold;
    private String thresholdType;
    private List<ThresholdMatchRule> matchRules = new LinkedList<ThresholdMatchRule>();
    private String className;
    private String data;
    private String unit;
    private boolean hardLimitNotificationsEnabled;
    private String hardLimitNotificationOperationTypeName;

    public ThresholdConfiguration() {
    }

    public ThresholdConfiguration(long id) {
        this.mId = id;
    }

    public ThresholdConfiguration(String name) {
        this.name = name;
    }

    ThresholdConfiguration(ThresholdConfiguration thresholdConfiguration) {
        super(thresholdConfiguration);
        this.name = thresholdConfiguration.name;
        this.description = thresholdConfiguration.description;
        this.threshold = thresholdConfiguration.threshold;
        this.thresholdType = thresholdConfiguration.thresholdType;
        this.className = thresholdConfiguration.className;
        this.data = thresholdConfiguration.data;
        this.hardLimitNotificationsEnabled = thresholdConfiguration.hardLimitNotificationsEnabled;
        this.hardLimitNotificationOperationTypeName = thresholdConfiguration.hardLimitNotificationOperationTypeName;
        this.unit = thresholdConfiguration.unit;
        thresholdConfiguration.matchRules.stream().map(o -> new ThresholdMatchRule((ThresholdMatchRule)o, this)).forEach(this.matchRules::add);
    }

    public ProfileService getService() {
        return this.profileService;
    }

    public void setService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }

    public BigDecimal getThreshold() {
        return this.threshold;
    }

    public String getThresholdType() {
        return this.thresholdType;
    }

    public void setThresholdType(String thresholdType) {
        this.thresholdType = thresholdType;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean hasUnit() {
        return this.unit != null;
    }

    public Unit getUnit() {
        return Unit.fromString(this.unit);
    }

    public void setUnit(Unit unit) {
        Preconditions.checkNotNull(unit);
        this.unit = unit.isEmpty() ? null : unit.getValue();
    }

    protected void validate() {
    }

    public List<ThresholdMatchRule> getMatchRules() {
        return this.matchRules;
    }

    public void setMatchRules(List<ThresholdMatchRule> matchRules) {
        this.matchRules = Preconditions.checkNotNull(matchRules);
    }

    public String toString() {
        return ThresholdConfiguration.class.getSimpleName() + "[id=" + this.mId + "]";
    }

    @Override
    public ThresholdConfiguration deepClone() {
        return new ThresholdConfiguration(this);
    }

    public boolean isSimilarTo(ThresholdConfiguration other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getUnit().equals(other.getUnit())) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.profileService != null && other.profileService != null && !this.profileService.equals(other.profileService)) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.thresholdType != null && other.thresholdType != null) {
            Object[] exitingUnitType = this.thresholdType.replaceAll(" ", "").split(",");
            Object[] otherUnitType = other.thresholdType.replaceAll(" ", "").split(",");
            Arrays.sort(otherUnitType);
            Arrays.sort(exitingUnitType);
            if (!Arrays.equals(exitingUnitType, otherUnitType)) {
                return false;
            }
        }
        for (ThresholdMatchRule cmr : this.matchRules) {
            if (other.matchRules.stream().filter(cmr::equalsToIgnoreId).findAny().isPresent()) continue;
            return false;
        }
        return true;
    }

    public boolean isHardLimitNotificationsEnabled() {
        return this.hardLimitNotificationsEnabled;
    }

    public void setHardLimitNotificationsEnabled(boolean hardLimitNotificationsEnabled) {
        this.hardLimitNotificationsEnabled = hardLimitNotificationsEnabled;
    }

    public String getHardLimitNotificationOperationTypeName() {
        return this.hardLimitNotificationOperationTypeName;
    }

    public void setHardLimitNotificationOperationTypeName(String hardLimitNotificationOperationTypeName) {
        this.hardLimitNotificationOperationTypeName = hardLimitNotificationOperationTypeName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasMatchingUnit(Unit expectedUnit) {
        Preconditions.checkNotNull(expectedUnit);
        return expectedUnit.match(this.getUnit());
    }

    @Override
    public void handleUnknownField(String fieldName, String fieldValue) {
        switch (fieldName) {
            case "unitType": {
                this.setThresholdType(fieldValue);
                break;
            }
            case "modifierUnitType": {
                this.matchRules = LegacyLimitsConverter.convertToThresholdMatchRules(fieldValue);
                break;
            }
        }
    }

    void setMatchRulesIfNotUpgraded(List<ThresholdMatchRule> matchRules) {
        if (!matchRules.isEmpty()) {
            this.setMatchRules(matchRules);
        }
    }
}

