/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.beust.jcommander.internal.Lists;
import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.limits.LegacyLimitsConverter;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfigurationFpDAO;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfigurationToUpdateFp;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

@Updatable
@Singleton
@Validatable
@CryptoKeys(keyAliases={"hier.thresholdconfig.S"})
public class ThresholdConfigurationFpDAOBean
extends CryptoExtendedBaseEntityDAOBean<ThresholdConfigurationToUpdateFp>
implements ThresholdConfigurationFpDAO {
    private static final List<TableColumn> TABLE_COLUMNS = Lists.newArrayList((Object[])TableColumn.values());
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    static final String FINGERPRINT_KEY = "hier.thresholdconfig.S";
    static final String DB_TABLENAME = "hier$thresholdconfig";

    protected ThresholdConfigurationToUpdateFp createManagedEntity() {
        return new ThresholdConfigurationToUpdateFp();
    }

    public ThresholdConfigurationToUpdateFp update(ThresholdConfigurationToUpdateFp threshold) {
        threshold = (ThresholdConfigurationToUpdateFp)super.update((BaseEntity)threshold);
        return threshold;
    }

    protected String getEntitySimpleName() {
        return ThresholdConfiguration.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getLong(TableColumn.FK_SERVICE.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getBigDecimal(TableColumn.THRESHOLD.name()), resultSet.getString(TableColumn.UNITTYPE.name()), resultSet.getString(TableColumn.CLASSNAME.name()), resultSet.getString(TableColumn.DATA.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name()), resultSet.getString(TableColumn.UNIT.name())};
        }
        return null;
    }

    public String getTableName() {
        return DB_TABLENAME;
    }

    public String getSequenceName() {
        return "hier$thresholdconfig_seq";
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        ThresholdConfigurationToUpdateFp thresholdConfiguration = (ThresholdConfigurationToUpdateFp)baseEntity;
        DateTime startDateTime = thresholdConfiguration.getStartDateTime();
        DateTime endDateTime = thresholdConfiguration.getEndDateTime();
        int i = 1;
        if (startDateTime != null) {
            preparedStatement.setObject(i++, (Object)ThresholdConfigurationFpDAOBean.getTimestamp((DateTime)startDateTime), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        if (endDateTime != null) {
            preparedStatement.setObject(i++, (Object)ThresholdConfigurationFpDAOBean.getTimestamp((DateTime)endDateTime), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        preparedStatement.setLong(i++, null != thresholdConfiguration.getService() ? thresholdConfiguration.getService().getId().longValue() : thresholdConfiguration.getFk_service());
        preparedStatement.setString(i++, thresholdConfiguration.getName());
        preparedStatement.setBigDecimal(i++, thresholdConfiguration.getThreshold());
        preparedStatement.setString(i++, thresholdConfiguration.getThresholdType());
        preparedStatement.setString(i++, null);
        preparedStatement.setString(i++, thresholdConfiguration.getClassName());
        preparedStatement.setString(i++, thresholdConfiguration.getData());
        preparedStatement.setString(i++, thresholdConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N");
        preparedStatement.setString(i++, thresholdConfiguration.getHardLimitNotificationOperationTypeName());
        preparedStatement.setString(i++, thresholdConfiguration.getDescription());
        preparedStatement.setString(i++, thresholdConfiguration.hasUnit() ? thresholdConfiguration.getUnit().getValue() : null);
        return this.assignFingerprint(preparedStatement, i, new Object[]{ThresholdConfigurationFpDAOBean.getTimestamp((DateTime)startDateTime), ThresholdConfigurationFpDAOBean.getTimestamp((DateTime)endDateTime), thresholdConfiguration.getService() != null ? thresholdConfiguration.getService().getId().longValue() : thresholdConfiguration.getFk_service(), thresholdConfiguration.getName(), thresholdConfiguration.getThreshold(), thresholdConfiguration.getThresholdType(), thresholdConfiguration.getClassName(), thresholdConfiguration.getData(), thresholdConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N", thresholdConfiguration.getHardLimitNotificationOperationTypeName(), thresholdConfiguration.getDescription(), thresholdConfiguration.hasUnit() ? thresholdConfiguration.getUnit().getValue() : null});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        ThresholdConfigurationToUpdateFp threshold = (ThresholdConfigurationToUpdateFp)baseEntity;
        threshold.setStartDateTime(ThresholdConfigurationFpDAOBean.getNullableDateTimeFromTimestampResultSet((ResultSet)resultSet, (String)TableColumn.STARTDATETIME.name()));
        threshold.setEndDateTime(ThresholdConfigurationFpDAOBean.getNullableDateTimeFromTimestampResultSet((ResultSet)resultSet, (String)TableColumn.ENDDATETIME.name()));
        threshold.setName(resultSet.getString(TableColumn.NAME.name()));
        threshold.setThreshold(resultSet.getBigDecimal(TableColumn.THRESHOLD.name()));
        threshold.setThresholdType(resultSet.getString(TableColumn.UNITTYPE.name()));
        threshold.setMatchRules(LegacyLimitsConverter.convertToThresholdMatchRules(resultSet.getString(TableColumn.MODIFIERUNITTYPE.name())));
        threshold.setClassName(resultSet.getString(TableColumn.CLASSNAME.name()));
        threshold.setData(resultSet.getString(TableColumn.DATA.name()));
        threshold.setHardLimitNotificationsEnabled(resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()).equals("Y"));
        threshold.setHardLimitNotificationOperationTypeName(resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()));
        threshold.setDescription(resultSet.getString(TableColumn.DESCRIPTION.name()));
        threshold.setUnit(Unit.fromString(resultSet.getString(TableColumn.UNIT.name())));
        threshold.setFk_service(resultSet.getLong(TableColumn.FK_SERVICE.name()));
    }

    public String[] getColumns() {
        return TABLE_COLUMNS.stream().map(Enum::name).collect(Collectors.toList()).toArray(new String[TableColumn.values().length]);
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    public ThresholdConfigurationToUpdateFp updateDefaultFingerprint(ThresholdConfigurationToUpdateFp entry) {
        return (ThresholdConfigurationToUpdateFp)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FINGERPRINTVERSION) + "= ? order by " + String.valueOf((Object)TableColumn.ID) + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    static enum TableColumn {
        ID,
        STARTDATETIME,
        ENDDATETIME,
        FK_SERVICE,
        NAME,
        THRESHOLD,
        UNITTYPE,
        MODIFIERUNITTYPE,
        CLASSNAME,
        DATA,
        HARDLIMITNOTIFICATIONSENABLED,
        HARDLIMITNOTIFICATIONNAME,
        DESCRIPTION,
        UNIT,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

