/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.http;

import com.ericsson.em.emc.UserException;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.http.UnexpectedErrorHandler;
import com.ericsson.lwac.http.types.ErrorArgument;
import com.ericsson.lwac.http.types.ErrorResponse;
import com.ericsson.lwac.http.types.Version;
import com.ericsson.lwac.http.xml.XmlErrorHandler;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import jakarta.persistence.OptimisticLockException;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Local(value={UnexpectedErrorHandler.class})
public class CoreErrorHandler
extends XmlErrorHandler {
    private static final String ERROR_MESSAGE = "message";
    private static final Logger logger = LoggerFactory.getLogger(CoreErrorHandler.class);

    @Override
    public ErrorResponse getErrorResponse(String operation, Version version, Exception e) {
        ErrorResponse errorResponse;
        if (e instanceof UserException) {
            UserException userException = (UserException)e;
            errorResponse = this.generateErrorResponse(userException.getErrorCode().toString(), userException.getArguments());
        } else if (e instanceof OptimisticLockException) {
            errorResponse = new ErrorResponse("RESOURCE_TEMPORARY_LOCKED");
        } else if (e instanceof ValidationException) {
            Map<String, Object> arguments = ((ValidationException)e).getArguments();
            arguments.put(ERROR_MESSAGE, e.getMessage());
            errorResponse = this.generateErrorResponse("VALIDATION_ERROR", arguments);
        } else {
            errorResponse = new ErrorResponse("INTERNAL_ERROR");
            logger.error("Uncaught error", e);
        }
        return errorResponse;
    }

    private ErrorResponse generateErrorResponse(String errorCode, Map<String, Object> errorArgMap) {
        LinkedList<ErrorArgument> arguments = new LinkedList<ErrorArgument>();
        for (Map.Entry<String, Object> argument : errorArgMap.entrySet()) {
            arguments.add(new ErrorArgument(argument.getKey(), argument.getValue() != null ? argument.getValue().toString() : null));
        }
        ErrorResponse errorResponse = new ErrorResponse(errorCode, arguments);
        return errorResponse;
    }
}

