/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.identityhelper;

import com.ericsson.em.emc.credential.persistence.Credential;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.identityhelper.ExtendedIdentity;
import com.ericsson.em.emc.identityhelper.IdentityHelper;
import com.ericsson.em.emc.identityhelper.IdentityIdentifier;
import com.google.common.annotations.VisibleForTesting;
import jakarta.ejb.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;

@Singleton
public class IdentityHelperBean
implements IdentityHelper {
    private final Map<String, IdentityIdentifier> handlers = new ConcurrentHashMap<String, IdentityIdentifier>();

    @Override
    public Optional<ExtendedIdentity> getExtendedIdentityByIdentityId(String type, Long id) {
        return Optional.ofNullable(this.handlers.get(type).getExtendedIdentityById(id));
    }

    @Override
    public void registerIdentityIdentifier(String type, IdentityIdentifier handler) {
        this.handlers.putIfAbsent(type, handler);
    }

    @Override
    public Optional<ExtendedIdentity> getExtendedIdentityByIdentity(String identity) {
        String type = this.getType(identity);
        return Optional.ofNullable(this.handlers.get(type).getExtendedIdentityByIdentity(identity));
    }

    @Override
    public Optional<List<ExtendedIdentity>> getExtendedIdentitiesByProfile(String type, Profile profile) {
        return Optional.ofNullable(this.handlers.containsKey(type) ? this.handlers.get(type).geExtendedIdentitiesByProfile(profile) : null);
    }

    @Override
    public Optional<DateTime> getUserLastLogin(String identity) {
        String type = this.getType(identity);
        return Optional.ofNullable(this.handlers.containsKey(type) ? this.handlers.get(type).getUserLastLogin(identity) : null);
    }

    @Override
    public Optional<Credential> getUserCredential(String identity) {
        String type = this.getType(identity);
        return Optional.ofNullable(this.handlers.containsKey(type) ? this.handlers.get(type).getUserCredential(identity) : null);
    }

    private String getType(String identity) {
        String type = "ACCOUNT_HOLDER";
        if (identity.contains("/ADMIN")) {
            type = "ADMIN";
        }
        return type;
    }

    @Override
    @VisibleForTesting
    public void clearHandlers() {
        this.handlers.clear();
    }
}

