/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.json;

import com.ericsson.em.emc.financial.FRI;
import com.ericsson.em.emc.financial.FriTypeRegister;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class FRIJsonAdapter
implements JsonDeserializer<FRI>,
JsonSerializer<FRI> {
    private final FriTypeRegister friTypeRegister;

    public FRIJsonAdapter(FriTypeRegister friTypeRegister) {
        this.friTypeRegister = friTypeRegister;
    }

    @Override
    public JsonElement serialize(FRI src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return null;
        }
        return new JsonPrimitive(src.toString());
    }

    @Override
    public FRI deserialize(JsonElement jsonelement, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (jsonelement.isJsonObject()) {
            JsonObject jsonObj = jsonelement.getAsJsonObject();
            String id = jsonObj.has("Id") ? jsonObj.get("Id").getAsString() : null;
            String typeStr = jsonObj.has("Type") ? jsonObj.get("Type").getAsString() : null;
            return this.friTypeRegister.createFriBuilder("FRI:" + id + "/" + typeStr).create();
        }
        return this.friTypeRegister.createFriBuilder(jsonelement.getAsString()).create();
    }
}

