/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.lifecycle;

import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.lifecycle.ProfileLifecycleEventListener;
import com.ericsson.em.emc.lifecycle.ProfileLifecycleEventManager;
import jakarta.ejb.Singleton;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProfileLifecycleEventManagerBean
implements ProfileLifecycleEventManager {
    private static final Logger logger = LoggerFactory.getLogger(ProfileLifecycleEventManagerBean.class);
    private final List<ProfileLifecycleEventListener> listeners = new CopyOnWriteArrayList<ProfileLifecycleEventListener>();

    @Override
    public void registerProfileLifecycleEventListener(ProfileLifecycleEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void importedProfile(Profile profile) {
        for (ProfileLifecycleEventListener listener : this.listeners) {
            try {
                listener.onProfileImported(profile);
            }
            catch (Exception e) {
                logger.debug("Exception caught when invoking listeners", e);
            }
        }
    }
}

