/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.lifecycle;

import com.ericsson.em.emc.lifecycle.UserLifecycleEventListener;
import com.ericsson.em.emc.lifecycle.UserLifecycleEventManager;
import jakarta.ejb.Singleton;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserLifecycleEventManagerBean
implements UserLifecycleEventManager {
    private static final Logger logger = LoggerFactory.getLogger(UserLifecycleEventManagerBean.class);
    private final List<UserLifecycleEventListener> listeners = new CopyOnWriteArrayList<UserLifecycleEventListener>();

    @Override
    public void registerUserLifecycleEventListener(UserLifecycleEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removedUser(String userIdentity) {
        for (UserLifecycleEventListener listener : this.listeners) {
            try {
                listener.onUserRemoved(userIdentity);
            }
            catch (Exception e) {
                logger.debug("Exception caught when invoking listeners", e);
            }
        }
    }
}

