/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.ericsson.em.emc.financial.CurrencyResolvedFRI;
import com.ericsson.em.emc.financial.FRI;
import com.ericsson.em.emc.financial.FriTypeRegister;
import com.ericsson.em.emc.financial.ResolvedFRI;
import com.ericsson.em.emc.financial.UnresolvedFRI;
import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.m3externallog.json.comparator.Difference;
import com.ericsson.em.emc.m3externallog.json.comparator.SerializableObject;
import com.ericsson.em.emc.m3externallog.json.converters.Converters;
import com.ericsson.em.emc.m3externallog.json.converters.CurrencyConverter;
import com.ericsson.em.emc.m3externallog.json.converters.CurrencyResolvedFRIWithHandlerConverter;
import com.ericsson.em.emc.m3externallog.json.converters.DateTimeConverter;
import com.ericsson.em.emc.m3externallog.json.converters.DifferenceConverter;
import com.ericsson.em.emc.m3externallog.json.converters.FRIConverterBean;
import com.ericsson.em.emc.m3externallog.json.converters.FRIWithHandlerConverter;
import com.ericsson.em.emc.m3externallog.json.converters.MoneyConverter;
import com.ericsson.em.emc.m3externallog.json.converters.ProfileReferenceConverter;
import com.ericsson.em.emc.m3externallog.json.converters.ResolvedFRIWithHandlerConverter;
import com.ericsson.em.emc.m3externallog.json.converters.SerializableObjectConverter;
import com.ericsson.em.emc.m3externallog.json.converters.UnitConverter;
import com.ericsson.em.emc.m3externallog.json.converters.UnresolvedFRIWithHandlerConverter;
import com.ericsson.em.emc.m3externallog.json.converters.XMLGregorianCalendarConverter;
import com.ericsson.em.emc.m3externallog.json.converters.XmlExtensionConverter;
import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;
import com.ericsson.em.emc.util.XmlExtension;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.joda.time.DateTime;

@Singleton
public class ConvertersBean
implements Converters {
    @EJB
    private FriTypeRegister friTypeRegister;
    private final Map<Class<?>, Object> converters = new HashMap();
    private final Map<Class<?>, Object> internalConverters = new HashMap();

    @Override
    public <T> void registerConverter(Class<T> clazz, Object converter) {
        this.converters.put(clazz, converter);
    }

    @Override
    public <T> void registerInternalConverter(Class<T> clazz, Object converter) {
        this.internalConverters.put(clazz, converter);
    }

    @PostConstruct
    public void postConstruct() {
        FRIConverterBean friConverter = new FRIConverterBean(this.friTypeRegister);
        this.converters.put(FRI.class, friConverter);
        this.converters.put(ResolvedFRI.class, friConverter);
        this.converters.put(UnresolvedFRI.class, friConverter);
        this.converters.put(Unit.class, new UnitConverter());
        this.converters.put(Currency.class, new CurrencyConverter());
        this.converters.put(Money.class, new MoneyConverter());
        this.converters.put(SerializableObject.class, new SerializableObjectConverter());
        this.converters.put(Difference.class, new DifferenceConverter());
        this.converters.put(DateTime.class, new DateTimeConverter());
        this.converters.put(XmlExtension.class, new XmlExtensionConverter());
        this.converters.put(ProfileReference.class, new ProfileReferenceConverter());
        try {
            this.converters.put(DatatypeFactory.newInstance().newXMLGregorianCalendar().getClass(), new XMLGregorianCalendarConverter());
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Serious configuration error, failed to construct XMLGregorianCalendar", e);
        }
        this.internalConverters.put(Currency.class, new CurrencyConverter());
        this.internalConverters.put(Money.class, new MoneyConverter());
        this.internalConverters.put(DateTime.class, new DateTimeConverter());
        this.internalConverters.put(FRI.class, new FRIWithHandlerConverter(this.friTypeRegister));
        this.internalConverters.put(UnresolvedFRI.class, new UnresolvedFRIWithHandlerConverter(this.friTypeRegister));
        this.internalConverters.put(ResolvedFRI.class, new ResolvedFRIWithHandlerConverter(this.friTypeRegister));
        this.internalConverters.put(CurrencyResolvedFRI.class, new CurrencyResolvedFRIWithHandlerConverter(this.friTypeRegister));
        this.internalConverters.put(XmlExtension.class, new XmlExtensionConverter());
        try {
            this.internalConverters.put(DatatypeFactory.newInstance().newXMLGregorianCalendar().getClass(), new XMLGregorianCalendarConverter());
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Serious configuration error, failed to construct XMLGregorianCalendar", e);
        }
    }

    @Override
    public Map<Class<?>, Object> getConverters() {
        return this.converters;
    }

    @Override
    public Map<Class<?>, Object> getInternalConverters() {
        return this.internalConverters;
    }
}

