/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.ericsson.em.emc.financial.FRI;
import com.ericsson.em.emc.financial.FriBuilder;
import com.ericsson.em.emc.financial.FriTypeRegister;
import com.ericsson.em.emc.m3externallog.json.converters.Converter;
import com.ericsson.em.emc.m3externallog.json.converters.FRIWithHandlerSerializer;
import com.ericsson.em.emc.util.Currency;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class FRIWithHandlerConverter
extends FRIWithHandlerSerializer
implements Converter<FRI> {
    private final FriTypeRegister friTypeRegister;
    private static final String CURRENCY = "Currency";
    private static final String RESOLVED_FROM = "ResolvedFrom";
    private static final String TYPE = "Type";
    private static final String ID = "Id";
    private static final String HANDLER = "Handler";

    public FRIWithHandlerConverter(FriTypeRegister friTypeRegister) {
        this.friTypeRegister = friTypeRegister;
    }

    @Override
    public FRI deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return this.deserialize(jsonElement);
    }

    private FRI deserialize(JsonElement jsonElement) {
        JsonElement resolvedFromElement;
        JsonElement currencyElement;
        JsonObject object = jsonElement.getAsJsonObject();
        String type = object.get(TYPE).getAsString();
        String id = object.get(ID).getAsString();
        FriBuilder friBuilder = this.friTypeRegister.createFriBuilder(type).withId(id);
        JsonElement handlerElement = object.get(HANDLER);
        if (handlerElement != null) {
            friBuilder.withHandler(handlerElement.getAsString());
        }
        if ((currencyElement = object.get(CURRENCY)) != null) {
            friBuilder.withCurrency(Currency.getInstance(currencyElement.getAsString()));
        }
        if ((resolvedFromElement = object.get(RESOLVED_FROM)) != null) {
            friBuilder.withResolvedFrom(this.deserialize(resolvedFromElement));
        }
        return friBuilder.create();
    }
}

