/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;

public class FileAdapter
extends TypeAdapter<File> {
    private static final String PATH_NAME = "path";

    @Override
    public void write(JsonWriter out, File value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name(PATH_NAME).value(value.getPath());
        out.endObject();
    }

    @Override
    public File read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String path = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (PATH_NAME.equals(name)) {
                path = in.nextString();
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return path != null ? new File(path) : null;
    }
}

