/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;

public class LocalDateAdapter
extends TypeAdapter<LocalDate> {
    @Override
    public void write(JsonWriter out, LocalDate localDate) throws IOException {
        if (localDate == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("year").value(localDate.getYear());
        out.name("month").value(localDate.getMonthValue());
        out.name("day").value(localDate.getDayOfMonth());
        out.endObject();
    }

    @Override
    public LocalDate read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        in.beginObject();
        block10: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "year": {
                    year = in.nextInt();
                    continue block10;
                }
                case "month": {
                    month = in.nextInt();
                    continue block10;
                }
                case "day": {
                    day = in.nextInt();
                    continue block10;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return LocalDate.of(year, month, day);
    }
}

