/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.ericsson.em.emc.m3externallog.json.converters.Converter;
import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public class MoneyConverter
implements Converter<Money> {
    private static final String CURRENCY = "Currency";
    private static final String AMOUNT = "Amount";

    @Override
    public Money deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        JsonElement amountElement = object.get(AMOUNT);
        JsonElement currencyElement = object.get(CURRENCY);
        String amount = amountElement.getAsString();
        Currency currency = (Currency)jsonDeserializationContext.deserialize(currencyElement, (Type)((Object)Currency.class));
        return Money.valueOf(amount, currency);
    }

    @Override
    public JsonElement serialize(Money src, Type srcType, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty(AMOUNT, src.toBigDecimal().toPlainString());
        obj.add(CURRENCY, context.serialize(src.getCurrency(), (Type)((Object)Currency.class)));
        return obj;
    }
}

