/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.ericsson.em.emm.ns.v2_0.common.Parameter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;

public class ParameterSerializer
implements JsonSerializer<Parameter> {
    private static final String NAME = "Name";
    private static final String VALUE = "Value";

    @Override
    public final JsonElement serialize(Parameter src, Type srcType, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty(NAME, src.getName().getValueAsString());
        if (src.getValue() != null) {
            object.addProperty(VALUE, src.getValue().isSensitive() ? this.maskString(src.getValue().getValueAsString(), 4) : src.getValue().getValueAsString());
        }
        return object;
    }

    private String maskString(String value, int visibleChars) {
        if (value == null) {
            return null;
        }
        int maskingLength = value.length() - Math.max(0, visibleChars);
        if (maskingLength < 1) {
            String masking = String.join((CharSequence)"", Collections.nCopies(value.length(), "*"));
            return masking;
        }
        String masking = String.join((CharSequence)"", Collections.nCopies(maskingLength, "*"));
        return value.substring(0, value.length() - maskingLength) + masking;
    }
}

