/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.notificationclient;

import com.ericsson.lwac.ErrorCode;

public enum NotificationCommunicationErrorCode implements ErrorCode
{
    NOTIFICATION_MISSING_PARAMETER(68002, "MISSING_PARAMETERS", "Notification server expected one or more parameter(s) in parameter list for operation: '%1$s', please check NS configuration.", 1),
    NOTIFICATION_UNKNOWN_OPERATION(68003, "UNKNOWN_OPERATION", "The operation '%1$s' is not known to the NS, please check NS configuration.", 1),
    NOTIFICATION_UNKNOWN_LANGUAGE_CODE(68004, "UNKNOWN_LANGUAGE_CODE", "The language code '%1$s' is not known to the NS, for operation: '%2$s', please check NS configuration.", 2),
    NOTIFICATION_UNKNOWN_CHANNEL(68005, "UNKNOWN_CHANNEL", "The channel '%1$s' is not known to the NS, for operation: '%2$s', please check NS configuration.", 2),
    NOTIFICATION_QUEUE_FULL(68006, "QUEUE_FULL", "Notification Server queue is full, Please try later.", 0),
    NOTIFICATION_INVALID_DATE_PARAMETER(68007, "INVALID_DATE_PARAMETER", "There is one or more date parameter(s) with invalid format in the request for operation: '%1$s'", 1),
    NOTIFICATION_INTERNAL_SERVER_ERROR(68008, "500", "Internal Server error occured while sending request for : '%1$s', Cause: %2$s", 2),
    NOTIFICATION_OTHER_ERROR(68009, "500", "Error in NotificationClient communication for operation: '%1$s', cause: %2$s", 2),
    NOTIFICATION_INVALID_TIME_PARAMETER(68010, "INVALID_TIME_PARAMETER", "There is one or more time parameter(s) with invalid format in the request for operation: '%1$s'.", 1),
    INVALID_NOTIFICATION_CHANNEL_FOR_OPERATION(68011, "INVALID_NOTIFICATION_CHANNEL_FOR_OPERATION", "The Notification Server requires valid receiver identity and channel, for operation: '%1$s'.", 1),
    NOTIFICATION_TEXT_NOT_FOUND(68012, "NOTIFICATION_TEXT_NOT_FOUND", "There is no notification text defined on the NS for operation: '%1$s'", 1),
    NOTIFICATION_VALIDATION_ERROR(68013, "VALIDATION_ERROR", "The request violates constraints, for operation: '%1$s'", 1),
    SYNC_FAILED(68014, "SYNC_FAILED", "Syncing of notifications with notification server failed.", 0),
    SYNC_CHECKSUM_FAILED(68015, "SYNC_CHECKSUM_FAILED", "Syncing of notifications with notification server failed due to invalid checksum.", 0);

    private final int errorId;
    private final String message;
    private final String protocolErrorCode;
    private final int numOfArguments;
    private static final int ERROR_GROUP = 68;

    private NotificationCommunicationErrorCode(int id, String errorCode, String message, int numOfParams) {
        this.errorId = id;
        this.message = message;
        this.protocolErrorCode = errorCode;
        this.numOfArguments = numOfParams;
    }

    @Override
    public int getErrorGroup() {
        return 68;
    }

    @Override
    public int getErrorCode() {
        return this.errorId % 1000;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getNumOfArgs() {
        return this.numOfArguments;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public String getProtocolErrorCode() {
        return this.protocolErrorCode;
    }

    public static NotificationCommunicationErrorCode getErrorCodeFromString(String errorCode) {
        NotificationCommunicationErrorCode code = NOTIFICATION_OTHER_ERROR;
        for (NotificationCommunicationErrorCode notificationErrorCode : NotificationCommunicationErrorCode.values()) {
            if (!errorCode.equals(notificationErrorCode.protocolErrorCode)) continue;
            code = notificationErrorCode;
            break;
        }
        return code;
    }
}

