/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.notificationclient;

import com.ericsson.em.emc.notificationclient.NotificationChannelType;
import com.ericsson.em.emc.notificationclient.NotificationIdentity;
import com.ericsson.em.emc.notificationclient.NotificationOperationType;
import com.ericsson.em.emc.notificationclient.internal.NotificationOperation;
import com.ericsson.em.emc.notificationclient.internal.Parameter;
import com.ericsson.em.emm.ns.v1_0.common.Iso8601DateTime;
import com.ericsson.em.emm.ns.v1_0.common.NotificationId;
import com.ericsson.em.emm.ns.v2_0.common.ReceiverIdentity;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.cli.ApplicationProperties;
import com.ericsson.lwac.deployer.service.ServiceLifecycle;
import com.ericsson.lwac.deployer.service.ServiceProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;

public interface NotificationService
extends ServiceLifecycle {
    public static final ApplicationProperties.ValidatableApplicationProperty BATCHTRANSACTION_TRANSFERNOTIFICATION_USEACCOUNTOWNERASSENDER = new ApplicationProperties.ValidatableApplicationProperty(){

        @Override
        public String getPropertyName() {
            return "batchtransaction.transfernotification.useaccountownerassender";
        }

        @Override
        public void validate(String value) throws ValidationException {
            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                return;
            }
            throw new ValidationException("Is not a boolean value");
        }

        @Override
        public String getDefaultValue() {
            return "false";
        }
    };

    public void sendNotification(NotificationIdentity var1, NotificationOperationType var2, List<Parameter> var3, String var4);

    public List<NotificationId> scheduleNotification(NotificationIdentity var1, NotificationOperationType var2, List<Parameter> var3, String var4, Iso8601DateTime var5);

    public void sendNotification(NotificationIdentity var1, NotificationOperationType var2, List<Parameter> var3, String var4, List<NotificationChannelType> var5);

    public void sendNotification(String var1, String var2, List<Parameter> var3, String var4, List<ReceiverIdentity> var5);

    public void sendNotification(NotificationIdentity var1, NotificationOperationType var2, NotificationChannelType var3, List<Parameter> var4, String var5);

    public void sendCustomNotification(NotificationIdentity var1, String var2, NotificationChannelType var3, List<Parameter> var4, String var5);

    public void setNotificationClientId(String var1);

    public void sendNotificationUnsynchronized(NotificationIdentity var1, NotificationOperationType var2, NotificationChannelType var3, List<Parameter> var4, String var5);

    public void sendNotificationUnsynchronized(NotificationIdentity var1, NotificationOperationType var2, List<Parameter> var3, String var4);

    public void registerNotificationOperation(NotificationOperationType[] var1);

    public List<NotificationOperation> createNotificationList();

    public String queryNotification(NotificationOperationType var1, NotificationChannelType var2, List<Parameter> var3, String var4);

    public void sendImageLogoToNotificationServer(String var1, String var2);

    public byte[] getImageLogoFromNotificationServer(String var1);

    public void deleteImageLogoFromNotificationServer(String var1);

    @VisibleForTesting
    public void syncNotificationsIfNeeded();

    public boolean isUseAccountOwnerAsSender();

    @ServiceProperty
    public void setUseAccountOwnerAsSender(boolean var1);
}

