/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.notificationclient.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.ericsson.em.emc.notificationclient.cli.NotificationClientCommandManager;
import com.ericsson.em.emc.notificationclient.internal.NotificationOperation;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cli.RemoteCLIEnvironment;
import com.ericsson.lwac.cli.commands.Command;
import com.ericsson.lwac.cli.commands.RemoteAction;
import com.ericsson.lwac.cli.commands.RemoteCommand;
import jakarta.ejb.EJB;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;

@Command(name="notification-client", group="m3")
@Parameters(separators="=")
@RemoteCommand
public class NotificationClientCommand {
    @EJB
    private NotificationClientCommandManager notificationClientCommandManager;

    @Command(name="compare")
    @Parameters(separators="=", commandDescription="Compare a notification server properties file with what is currently available in m3.")
    private class CompareCommand
    implements RemoteAction {
        @Parameter(description="Fully qualified file path to a notification server properties file to compare with.", names={"-f", "--file"}, required=true)
        private String name;

        private CompareCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            File file = new File(this.name);
            if (file.exists() && file.canRead() && file.isFile()) {
                Properties fileProperties = new Properties();
                try (FileInputStream fis = new FileInputStream(file);){
                    fileProperties.load(fis);
                }
                catch (IOException e) {
                    environment.getOutputWriter().println(String.format("Failed to load '%s' due to %s", this.name, e.getMessage()));
                }
                Properties systemProperties = this.getSystemNotificationsAsProperties();
                List<String> missingFromFile = this.compare(systemProperties, fileProperties);
                List<String> missingFromSystem = this.compare(fileProperties, systemProperties);
                environment.getOutputWriter().println(String.format("Available notifications in system but missing from '%s':", file.getName()));
                missingFromFile.stream().sorted(String::compareToIgnoreCase).forEach(notification -> environment.getOutputWriter().println((String)notification));
                environment.getOutputWriter().println("---");
                environment.getOutputWriter().println(String.format("Available notifications in '%s' but missing in system;", file.getName()));
                missingFromSystem.stream().sorted(String::compareToIgnoreCase).forEach(notification -> environment.getOutputWriter().println((String)notification));
            } else {
                environment.getOutputWriter().println(String.format("Failed to read from file '%s', make sure it exists and is readable.", file.getName()));
            }
        }

        private List<String> compare(Properties base, Properties other) {
            ArrayList<String> missing = new ArrayList<String>();
            base.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(notification, message) -> {
                if (other.get(notification) == null) {
                    missing.add((String)notification);
                }
            }));
            return missing;
        }

        private Properties getSystemNotificationsAsProperties() {
            Properties properties = new Properties();
            NotificationClientCommand.this.notificationClientCommandManager.listAll().forEach(notification -> properties.put(notification.getOperation(), notification.getDefaultMessage()));
            return properties;
        }
    }

    @Command(name="list")
    @Parameters(separators="=", commandDescription="List all available notifications currently available in the system.")
    private class ListCommand
    implements RemoteAction {
        @Parameter(description="Verbose output including operation with default message.", names={"-v"})
        private boolean includeMessage;

        private ListCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            List<NotificationOperation> notifications = NotificationClientCommand.this.notificationClientCommandManager.listAll();
            environment.getOutputWriter().println("List of currently active notifications");
            if (notifications != null) {
                notifications.forEach(notification -> environment.getOutputWriter().println(notification.getOperation() + (String)(this.includeMessage ? "=" + notification.getDefaultMessage() : "")));
            }
        }
    }
}

