/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.notificationreceiver;

import com.ericsson.em.emc.notificationclient.NotificationIdentity;
import com.ericsson.em.emc.notificationreceiver.NotificationReceiverService;
import com.ericsson.em.emc.notificationreceiver.persistence.NotificationReceiver;
import com.ericsson.em.emc.notificationreceiver.persistence.NotificationReceiverDAO;
import com.ericsson.lwac.deployer.service.Service;
import com.google.common.collect.ImmutableList;
import jakarta.ejb.EJB;
import java.util.List;
import java.util.Optional;

@Service(serviceInterface=NotificationReceiverService.class)
public class NotificationReceiverServiceBean
implements NotificationReceiverService {
    @EJB
    private NotificationReceiverDAO notificationReceiverDAO;
    private List<String> applicableNotifications = ImmutableList.of();

    @Override
    public List<String> getApplicableNotifications() {
        return this.applicableNotifications;
    }

    @Override
    public void setApplicableNotifications(List<String> notifications) {
        this.applicableNotifications = ((ImmutableList.Builder)ImmutableList.builder().addAll(notifications)).build();
    }

    @Override
    public boolean isApplicableNotification(String operationName) {
        return this.applicableNotifications.contains(operationName);
    }

    @Override
    public Optional<List<NotificationReceiver>> getNotificationReceivers(NotificationIdentity notificationIdentity) {
        return notificationIdentity.getAccountHolderIdentity().map(this.notificationReceiverDAO::findNotificationReceiversByAccountHolderId);
    }
}

